/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import htsjdk.samtools.SAMSequenceDictionary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionReadShardArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerContext;
import org.broadinstitute.hellbender.engine.spark.FindAssemblyRegionsSpark;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class AssemblyRegionWalkerSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @ArgumentCollection
    public final AssemblyRegionReadShardArgumentCollection shardingArgs = new AssemblyRegionReadShardArgumentCollection();
    @ArgumentCollection
    public final AssemblyRegionArgumentCollection assemblyRegionArgs = new AssemblyRegionArgumentCollection();
    @Argument(doc="whether to use the shuffle implementation or not", shortName="shuffle", fullName="shuffle", optional=true)
    public boolean shuffle = false;
    @Argument(doc="whether to use the strict implementation or not (defaults to the faster implementation that doesn't strictly match the walker version)", fullName="strict", optional=true)
    public boolean strict = false;
    private String referenceFileName;
    private List<ShardBoundary> intervalShards;

    @Override
    public final boolean requiresReads() {
        return true;
    }

    @Override
    public final boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> defaultFilters = new ArrayList<ReadFilter>(2);
        defaultFilters.add(new WellformedReadFilter());
        defaultFilters.add(new ReadFilterLibrary.MappedReadFilter());
        return defaultFilters;
    }

    public abstract AssemblyRegionEvaluator assemblyRegionEvaluator();

    protected Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast(JavaSparkContext ctx) {
        return AssemblyRegionWalkerSpark.assemblyRegionEvaluatorSupplierBroadcastFunction(ctx, this.assemblyRegionEvaluator());
    }

    private static Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcastFunction(JavaSparkContext ctx, AssemblyRegionEvaluator assemblyRegionEvaluator) {
        Supplier supplier = (Supplier<AssemblyRegionEvaluator> & Serializable)() -> assemblyRegionEvaluator;
        return ctx.broadcast((Object)supplier);
    }

    @Override
    protected List<SimpleInterval> editIntervals(List<SimpleInterval> rawIntervals) {
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<SimpleInterval> intervals = rawIntervals == null ? IntervalUtils.getAllIntervalsForReference(sequenceDictionary) : rawIntervals;
        this.intervalShards = intervals.stream().flatMap(interval -> Shard.divideIntervalIntoShards(interval, this.shardingArgs.readShardSize, this.shardingArgs.readShardPadding, sequenceDictionary).stream()).collect(Collectors.toList());
        List<SimpleInterval> paddedIntervalsForReads = intervals.stream().map(interval -> interval.expandWithinContig(this.shardingArgs.readShardPadding, sequenceDictionary)).collect(Collectors.toList());
        return paddedIntervalsForReads;
    }

    protected JavaRDD<AssemblyRegionWalkerContext> getAssemblyRegions(JavaSparkContext ctx) {
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (this.strict) {
            return FindAssemblyRegionsSpark.getAssemblyRegionsStrict(ctx, this.getReads(), this.getHeaderForReads(), sequenceDictionary, this.referenceFileName, this.features, this.intervalShards, this.assemblyRegionEvaluatorSupplierBroadcast(ctx), this.shardingArgs, this.assemblyRegionArgs, this.shuffle);
        }
        return FindAssemblyRegionsSpark.getAssemblyRegionsFast(ctx, this.getReads(), this.getHeaderForReads(), sequenceDictionary, this.referenceFileName, this.features, this.intervalShards, this.assemblyRegionEvaluatorSupplierBroadcast(ctx), this.shardingArgs, this.assemblyRegionArgs, this.shuffle);
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.referenceFileName = AssemblyRegionWalkerSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        this.processAssemblyRegions(this.getAssemblyRegions(ctx), ctx);
    }

    protected abstract void processAssemblyRegions(JavaRDD<AssemblyRegionWalkerContext> var1, JavaSparkContext var2);
}

