/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.ActivityProfileStateIterator;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.AssemblyRegionFromActivityProfileStateIterator;
import org.broadinstitute.hellbender.engine.AssemblyRegionIterator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.MultiIntervalShard;
import org.broadinstitute.hellbender.engine.ReadlessAssemblyRegion;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.engine.ShardBoundaryShard;
import org.broadinstitute.hellbender.engine.ShardToMultiIntervalShardAdapter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionReadShardArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerContext;
import org.broadinstitute.hellbender.engine.spark.SparkSharder;
import org.broadinstitute.hellbender.tools.DownsampleableSparkReadShard;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileStateRange;
import org.broadinstitute.hellbender.utils.downsampling.PositionalDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public class FindAssemblyRegionsSpark {
    public static JavaRDD<AssemblyRegionWalkerContext> getAssemblyRegionsFast(JavaSparkContext ctx, JavaRDD<GATKRead> reads, SAMFileHeader header, SAMSequenceDictionary sequenceDictionary, String referenceFileName, FeatureManager features, List<ShardBoundary> intervalShards, Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast, AssemblyRegionReadShardArgumentCollection shardingArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, boolean shuffle) {
        JavaRDD<Shard<GATKRead>> shardedReads = SparkSharder.shard(ctx, reads, GATKRead.class, sequenceDictionary, intervalShards, shardingArgs.readShardSize, shuffle);
        Broadcast bFeatureManager = features == null ? null : ctx.broadcast((Object)features);
        return shardedReads.mapPartitions(FindAssemblyRegionsSpark.getAssemblyRegionsFunctionFast(referenceFileName, (Broadcast<FeatureManager>)bFeatureManager, header, assemblyRegionEvaluatorSupplierBroadcast, assemblyRegionArgs));
    }

    private static FlatMapFunction<Iterator<Shard<GATKRead>>, AssemblyRegionWalkerContext> getAssemblyRegionsFunctionFast(String referenceFileName, Broadcast<FeatureManager> bFeatureManager, SAMFileHeader header, Broadcast<Supplier<AssemblyRegionEvaluator>> supplierBroadcast, AssemblyRegionArgumentCollection assemblyRegionArgs) {
        return (FlatMapFunction & Serializable)shardedReadIterator -> {
            ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            AssemblyRegionEvaluator assemblyRegionEvaluator = (AssemblyRegionEvaluator)((Supplier)supplierBroadcast.getValue()).get();
            PositionalDownsampler readsDownsampler = assemblyRegionArgs.maxReadsPerAlignmentStart > 0 ? new PositionalDownsampler(assemblyRegionArgs.maxReadsPerAlignmentStart, header) : null;
            Iterator iterators = Utils.stream(shardedReadIterator).map(shardedRead -> new ShardToMultiIntervalShardAdapter<GATKRead>(new DownsampleableSparkReadShard(new ShardBoundary(shardedRead.getInterval(), shardedRead.getPaddedInterval()), (Iterable<GATKRead>)shardedRead, readsDownsampler))).map(downsampledShardedRead -> {
                AssemblyRegionIterator assemblyRegionIter = new AssemblyRegionIterator(new ShardToMultiIntervalShardAdapter<GATKRead>((Shard<GATKRead>)downsampledShardedRead), header, reference, features, assemblyRegionEvaluator, assemblyRegionArgs);
                return Utils.stream(assemblyRegionIter).map(assemblyRegion -> new AssemblyRegionWalkerContext((AssemblyRegion)assemblyRegion, new ReferenceContext(reference, assemblyRegion.getPaddedSpan()), new FeatureContext(features, assemblyRegion.getPaddedSpan()))).iterator();
            }).iterator();
            return Iterators.concat(iterators);
        };
    }

    public static JavaRDD<AssemblyRegionWalkerContext> getAssemblyRegionsStrict(JavaSparkContext ctx, JavaRDD<GATKRead> reads, SAMFileHeader header, SAMSequenceDictionary sequenceDictionary, String referenceFileName, FeatureManager features, List<ShardBoundary> intervalShards, Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast, AssemblyRegionReadShardArgumentCollection shardingArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, boolean shuffle) {
        JavaRDD<Shard<GATKRead>> shardedReads = SparkSharder.shard(ctx, reads, GATKRead.class, sequenceDictionary, intervalShards, shardingArgs.readShardSize, shuffle);
        Broadcast bFeatureManager = features == null ? null : ctx.broadcast((Object)features);
        JavaRDD activityProfileStates = shardedReads.mapPartitions(FindAssemblyRegionsSpark.getActivityProfileStatesFunction(referenceFileName, (Broadcast<FeatureManager>)bFeatureManager, header, assemblyRegionEvaluatorSupplierBroadcast, assemblyRegionArgs));
        JavaPairRDD contigToGroupedStates = activityProfileStates.keyBy((org.apache.spark.api.java.function.Function & Serializable)range -> range.getContig()).groupByKey();
        JavaRDD readlessAssemblyRegions = contigToGroupedStates.flatMap(FindAssemblyRegionsSpark.getReadlessAssemblyRegionsFunction(header, assemblyRegionArgs));
        readlessAssemblyRegions = readlessAssemblyRegions.repartition(readlessAssemblyRegions.getNumPartitions());
        JavaRDD<Shard<GATKRead>> assemblyRegionShardedReads = SparkSharder.shard(ctx, reads, GATKRead.class, header.getSequenceDictionary(), readlessAssemblyRegions, shardingArgs.readShardSize);
        JavaRDD assemblyRegions = assemblyRegionShardedReads.mapPartitions((FlatMapFunction & Serializable)shardedReadIterator -> {
            PositionalDownsampler readsDownsampler = assemblyRegionArgs.maxReadsPerAlignmentStart > 0 ? new PositionalDownsampler(assemblyRegionArgs.maxReadsPerAlignmentStart, header) : null;
            return Utils.stream(shardedReadIterator).map(shardedRead -> FindAssemblyRegionsSpark.toAssemblyRegion(shardedRead, header, readsDownsampler)).iterator();
        });
        return assemblyRegions.mapPartitions(FindAssemblyRegionsSpark.getAssemblyRegionWalkerContextFunction(referenceFileName, (Broadcast<FeatureManager>)bFeatureManager));
    }

    private static FlatMapFunction<Iterator<Shard<GATKRead>>, ActivityProfileStateRange> getActivityProfileStatesFunction(String referenceFileName, Broadcast<FeatureManager> bFeatureManager, SAMFileHeader header, Broadcast<Supplier<AssemblyRegionEvaluator>> supplierBroadcast, AssemblyRegionArgumentCollection assemblyRegionArgs) {
        return (FlatMapFunction & Serializable)shardedReadIterator -> {
            ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            AssemblyRegionEvaluator assemblyRegionEvaluator = (AssemblyRegionEvaluator)((Supplier)supplierBroadcast.getValue()).get();
            return Utils.stream(shardedReadIterator).map(shardedRead -> {
                PositionalDownsampler readsDownsampler = assemblyRegionArgs.maxReadsPerAlignmentStart > 0 ? new PositionalDownsampler(assemblyRegionArgs.maxReadsPerAlignmentStart, header) : null;
                return new ShardToMultiIntervalShardAdapter<GATKRead>(new DownsampleableSparkReadShard(new ShardBoundary(shardedRead.getInterval(), shardedRead.getPaddedInterval()), (Iterable<GATKRead>)shardedRead, readsDownsampler));
            }).map(shardedRead -> {
                ActivityProfileStateIterator activityProfileStateIter = new ActivityProfileStateIterator(new ShardToMultiIntervalShardAdapter<GATKRead>((Shard<GATKRead>)shardedRead), header, reference, features, assemblyRegionEvaluator);
                return new ActivityProfileStateRange((MultiIntervalShard<?>)shardedRead, activityProfileStateIter);
            }).iterator();
        };
    }

    private static FlatMapFunction<Tuple2<String, Iterable<ActivityProfileStateRange>>, ReadlessAssemblyRegion> getReadlessAssemblyRegionsFunction(SAMFileHeader header, AssemblyRegionArgumentCollection assemblyRegionArgs) {
        return (FlatMapFunction & Serializable)iter -> Iterators.transform((Iterator)new AssemblyRegionFromActivityProfileStateIterator(ActivityProfileStateRange.toIteratorActivityProfileState(((Iterable)iter._2).iterator()), header, assemblyRegionArgs.minAssemblyRegionSize, assemblyRegionArgs.maxAssemblyRegionSize, assemblyRegionArgs.assemblyRegionPadding, assemblyRegionArgs.activeProbThreshold, assemblyRegionArgs.maxProbPropagationDistance), (Function)new Function<AssemblyRegion, ReadlessAssemblyRegion>(){

            @Nullable
            public ReadlessAssemblyRegion apply(@Nullable AssemblyRegion input) {
                return new ReadlessAssemblyRegion(input);
            }
        });
    }

    private static AssemblyRegion toAssemblyRegion(Shard<GATKRead> shard, SAMFileHeader header, ReadsDownsampler readsDownsampler) {
        DownsampleableSparkReadShard downsampledShardedRead = new DownsampleableSparkReadShard(new ShardBoundary(shard.getInterval(), shard.getPaddedInterval()), shard, readsDownsampler);
        ReadlessAssemblyRegion readlessAssemblyRegion = (ReadlessAssemblyRegion)((ShardBoundaryShard)shard).getShardBoundary();
        int extension = Math.max(shard.getInterval().getStart() - shard.getPaddedInterval().getStart(), shard.getPaddedInterval().getEnd() - shard.getInterval().getEnd());
        AssemblyRegion assemblyRegion = new AssemblyRegion(shard.getInterval(), readlessAssemblyRegion.isActive(), extension, header);
        assemblyRegion.addAll(Lists.newArrayList((Iterable)downsampledShardedRead));
        return assemblyRegion;
    }

    private static FlatMapFunction<Iterator<AssemblyRegion>, AssemblyRegionWalkerContext> getAssemblyRegionWalkerContextFunction(String referenceFileName, Broadcast<FeatureManager> bFeatureManager) {
        return (FlatMapFunction & Serializable)assemblyRegionIter -> {
            ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            return Utils.stream(assemblyRegionIter).map(assemblyRegion -> new AssemblyRegionWalkerContext((AssemblyRegion)assemblyRegion, new ReferenceContext(reference, assemblyRegion.getPaddedSpan()), new FeatureContext(features, assemblyRegion.getPaddedSpan()))).iterator();
        };
    }
}

