/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.spark.serializer.KryoRegistrator;
import org.bdgenomics.adam.serialization.ADAMKryoRegistrator;
import org.broadinstitute.hellbender.engine.spark.SAMRecordSerializer;
import org.broadinstitute.hellbender.engine.spark.SAMRecordToGATKReadAdapterSerializer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSparkUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;
import org.broadinstitute.hellbender.utils.read.markduplicates.ReadsKey;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.EmptyFragment;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Fragment;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Pair;
import org.broadinstitute.hellbender.utils.read.markduplicates.sparkrecords.Passthrough;
import org.objenesis.instantiator.ObjectInstantiator;

public class GATKRegistrator
implements KryoRegistrator {
    private final ADAMKryoRegistrator ADAMregistrator = new ADAMKryoRegistrator();

    @VisibleForTesting
    public static void registerFuncotationMapDependencies(Kryo kryo) {
        Utils.nonNull(kryo);
        Registration registration = kryo.register(TableFuncotation.class);
        registration.setInstantiator((ObjectInstantiator)new ObjectInstantiator<TableFuncotation>(){

            public TableFuncotation newInstance() {
                return TableFuncotation.create(new LinkedHashMap<String, String>(), Allele.UNSPECIFIED_ALTERNATE_ALLELE, "TEMP", null);
            }
        });
        registration = kryo.register(VcfFuncotationMetadata.class);
        registration.setInstantiator((ObjectInstantiator)new ObjectInstantiator<VcfFuncotationMetadata>(){

            public VcfFuncotationMetadata newInstance() {
                return VcfFuncotationMetadata.create(new ArrayList<VCFInfoHeaderLine>());
            }
        });
        registration = kryo.register(VCFInfoHeaderLine.class);
        registration.setInstantiator((ObjectInstantiator)new ObjectInstantiator<VCFInfoHeaderLine>(){

            public VCFInfoHeaderLine newInstance() {
                return new VCFInfoHeaderLine("TMP", 2, VCFHeaderLineType.String, "");
            }
        });
        registration = kryo.register(Allele.class);
        registration.setInstantiator((ObjectInstantiator)new ObjectInstantiator<Allele>(){

            public Allele newInstance() {
                return Allele.create((String)"TCGA");
            }
        });
    }

    public void registerClasses(Kryo kryo) {
        this.registerGATKClasses(kryo);
        this.ADAMregistrator.registerClasses(kryo);
        this.registerGATKClasses(kryo);
    }

    private void registerGATKClasses(Kryo kryo) {
        kryo.register(Collections.nCopies(2, "").getClass(), (Serializer)new FieldSerializer(kryo, Collections.nCopies(2, "").getClass()));
        kryo.register(Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass(), (Serializer)new UnmodifiableCollectionsSerializer());
        kryo.register(Collections.unmodifiableList(Collections.EMPTY_LIST).getClass(), (Serializer)new UnmodifiableCollectionsSerializer());
        kryo.register(ImmutableMap.of().getClass(), (Serializer)new ImmutableMapSerializer());
        kryo.register(ImmutableMap.of((Object)"one", (Object)"element").getClass(), (Serializer)new ImmutableMapSerializer());
        kryo.register(ImmutableMap.of((Object)"map", (Object)"with", (Object)"multiple", (Object)"elements").getClass(), (Serializer)new ImmutableMapSerializer());
        kryo.register(SAMRecordToGATKReadAdapter.class, (Serializer)new SAMRecordToGATKReadAdapterSerializer());
        kryo.register(SAMRecord.class, (Serializer)new SAMRecordSerializer());
        kryo.register(BAMRecord.class, (Serializer)new SAMRecordSerializer());
        kryo.register(SAMFileHeader.class);
        kryo.register(SAMFileHeader.GroupOrder.class);
        kryo.register(SAMFileHeader.SortOrder.class);
        kryo.register(SAMProgramRecord.class);
        kryo.register(SAMReadGroupRecord.class);
        kryo.register(EmptyFragment.class, (Serializer)new FieldSerializer(kryo, EmptyFragment.class));
        kryo.register(Fragment.class, (Serializer)new FieldSerializer(kryo, Fragment.class));
        kryo.register(Pair.class, (Serializer)new Pair.Serializer());
        kryo.register(Passthrough.class, (Serializer)new FieldSerializer(kryo, Passthrough.class));
        kryo.register(MarkDuplicatesSparkUtils.IndexPair.class, (Serializer)new FieldSerializer(kryo, MarkDuplicatesSparkUtils.IndexPair.class));
        kryo.register(ReadsKey.class, (Serializer)new FieldSerializer(kryo, ReadsKey.class));
        kryo.register(ReadsKey.KeyForFragment.class, (Serializer)new FieldSerializer(kryo, ReadsKey.KeyForFragment.class));
        kryo.register(ReadsKey.KeyForPair.class, (Serializer)new FieldSerializer(kryo, ReadsKey.KeyForPair.class));
    }
}

