/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import htsjdk.io.IOPath;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKAnnotationPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.argumentcollections.IntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredIntervalArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredReadInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.SequenceDictionaryValidationArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.TraversalParameters;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.SparkCommandLineProgram;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSink;
import org.broadinstitute.hellbender.engine.spark.datasources.ReadsSparkSource;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceWindowFunctions;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.SerializableFunction;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadsWriteFormat;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public abstract class GATKSparkTool
extends SparkCommandLineProgram {
    private static final long serialVersionUID = 1L;
    public static final String BAM_PARTITION_SIZE_LONG_NAME = "bam-partition-size";
    public static final String NUM_REDUCERS_LONG_NAME = "num-reducers";
    public static final String SHARDED_OUTPUT_LONG_NAME = "sharded-output";
    public static final String OUTPUT_SHARD_DIR_LONG_NAME = "output-shard-tmp-dir";
    public static final String CREATE_OUTPUT_BAM_SPLITTING_INDEX_LONG_NAME = "create-output-bam-splitting-index";
    public static final String USE_NIO = "use-nio";
    public static final String SPLITTING_INDEX_GRANULARITY = "splitting-index-granularity";
    @ArgumentCollection
    public final ReferenceInputArgumentCollection referenceArguments = this.requiresReference() ? new RequiredReferenceInputArgumentCollection() : new OptionalReferenceInputArgumentCollection();
    @ArgumentCollection
    public final ReadInputArgumentCollection readArguments = this.requiresReads() ? new RequiredReadInputArgumentCollection() : new OptionalReadInputArgumentCollection();
    @ArgumentCollection
    protected IntervalArgumentCollection intervalArgumentCollection = this.requiresIntervals() ? new RequiredIntervalArgumentCollection() : new OptionalIntervalArgumentCollection();
    @Argument(doc="maximum number of bytes to read from a file into each partition of reads. Setting this higher will result in fewer partitions. Note that this will not be equal to the size of the partition in memory. Defaults to 0, which uses the default split size (determined by the Hadoop input format, typically the size of one HDFS block).", fullName="bam-partition-size", optional=true)
    protected long bamPartitionSplitSize = 0L;
    @Argument(doc="Whether to use NIO or the Hadoop filesystem (default) for reading files. (Note that the Hadoop filesystem is always used for writing files.)", fullName="use-nio", optional=true)
    protected boolean useNio = false;
    @ArgumentCollection
    protected SequenceDictionaryValidationArgumentCollection sequenceDictionaryValidationArguments = this.getSequenceDictionaryValidationArgumentCollection();
    @Argument(fullName="add-output-vcf-command-line", shortName="add-output-vcf-command-line", doc="If true, adds a command line header line to created VCF files.", optional=true, common=true)
    public boolean addOutputVCFCommandLine = true;
    @Argument(doc="For tools that write an output, write the output in multiple pieces (shards)", fullName="sharded-output", optional=true, mutex={"output-shard-tmp-dir"})
    protected boolean shardedOutput = false;
    @Argument(doc="when writing a bam, in single sharded mode this directory to write the temporary intermediate output shards, if not specified .parts/ will be used", fullName="output-shard-tmp-dir", optional=true, mutex={"sharded-output"})
    protected String shardedPartsDir = null;
    @Argument(doc="For tools that shuffle data or write an output, sets the number of reducers. Defaults to 0, which gives one partition per 10MB of input.", fullName="num-reducers", optional=true)
    protected int numReducers = 0;
    @Argument(fullName="create-output-bam-index", shortName="OBI", doc="If true, create a BAM index when writing a coordinate-sorted BAM file.", optional=true, common=true)
    public boolean createOutputBamIndex = ConfigFactory.getInstance().getGATKConfig().createOutputBamIndex();
    @Argument(fullName="create-output-bam-splitting-index", doc="If true, create a BAM splitting index (SBI) when writing a coordinate-sorted BAM file.", optional=true, common=true)
    public boolean createOutputBamSplittingIndex = ConfigFactory.getInstance().getGATKConfig().createOutputBamIndex();
    @Argument(fullName="splitting-index-granularity", doc="Granularity to use when writing a splitting index, one entry will be put into the index every n reads where n is this granularity value. Smaller granularity results in a larger index with more available split points.", optional=true, common=true, minValue=1.0)
    public long splittingIndexGranularity = 4096L;
    @Argument(fullName="create-output-variant-index", shortName="OVI", doc="If true, create a VCF index when writing a coordinate-sorted VCF file.", optional=true, common=true)
    public boolean createOutputVariantIndex = true;
    private ReadsSparkSource readsSource;
    private SAMFileHeader readsHeader;
    private LinkedHashMap<GATKPath, SAMFileHeader> readInputs;
    private ReferenceMultiSparkSource referenceSource;
    private SAMSequenceDictionary referenceDictionary;
    private List<SimpleInterval> userIntervals;
    protected FeatureManager features;

    @Override
    public List<? extends CommandLinePluginDescriptor<?>> getPluginDescriptors() {
        GATKReadFilterPluginDescriptor readFilterDescriptor = new GATKReadFilterPluginDescriptor(this.getDefaultReadFilters());
        return this.useVariantAnnotations() ? Arrays.asList(new CommandLinePluginDescriptor[]{readFilterDescriptor, new GATKAnnotationPluginDescriptor(this.getDefaultVariantAnnotations(), this.getDefaultVariantAnnotationGroups())}) : Collections.singletonList(readFilterDescriptor);
    }

    public boolean requiresReference() {
        return false;
    }

    public boolean requiresReads() {
        return false;
    }

    public ReadInputMergingPolicy getReadInputMergingPolicy() {
        return ReadInputMergingPolicy.doNotMerge;
    }

    public boolean requiresIntervals() {
        return false;
    }

    public final boolean hasReference() {
        return this.referenceSource != null;
    }

    public final boolean hasReads() {
        return this.readsSource != null;
    }

    public final boolean hasUserSuppliedIntervals() {
        return this.userIntervals != null;
    }

    public SerializableFunction<GATKRead, SimpleInterval> getReferenceWindowFunction() {
        return ReferenceWindowFunctions.IDENTITY_FUNCTION;
    }

    protected SequenceDictionaryValidationArgumentCollection getSequenceDictionaryValidationArgumentCollection() {
        return new SequenceDictionaryValidationArgumentCollection.StandardValidationCollection();
    }

    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        return this.hasReference() ? this.referenceDictionary : (this.hasReads() ? this.readsHeader.getSequenceDictionary() : null);
    }

    public SAMSequenceDictionary getReferenceSequenceDictionary() {
        return this.referenceDictionary;
    }

    public SAMFileHeader getHeaderForReads() {
        return this.readsHeader;
    }

    public JavaRDD<GATKRead> getReads() {
        ReadFilter filter = this.makeReadFilter();
        return this.getUnfilteredReads().filter((Function & Serializable)read -> filter.test((GATKRead)read));
    }

    public JavaRDD<GATKRead> getUnfilteredReads() {
        TraversalParameters traversalParameters;
        if (this.hasUserSuppliedIntervals()) {
            boolean traverseUnmapped = this.intervalArgumentCollection.intervalsSpecified() ? this.intervalArgumentCollection.getTraversalParameters(this.getHeaderForReads().getSequenceDictionary()).traverseUnmappedReads() : false;
            traversalParameters = new TraversalParameters(this.getIntervals(), traverseUnmapped);
        } else {
            traversalParameters = null;
        }
        JavaRDD output = null;
        ReadsSparkSource source = this.readsSource;
        for (GATKPath inputPathSpecifier : this.readInputs.keySet()) {
            if (output == null) {
                output = this.getGatkReadJavaRDD(traversalParameters, source, inputPathSpecifier);
                continue;
            }
            output = output.union(this.getGatkReadJavaRDD(traversalParameters, source, inputPathSpecifier));
        }
        return output;
    }

    protected JavaRDD<GATKRead> getGatkReadJavaRDD(TraversalParameters traversalParameters, ReadsSparkSource source, GATKPath inputSpecifier) {
        JavaRDD<GATKRead> output;
        if (inputSpecifier.hasExtension(".adam")) {
            try {
                output = source.getADAMReads(inputSpecifier, traversalParameters, this.getHeaderForReads());
            }
            catch (IOException e) {
                throw new UserException("Failed to read ADAM file " + inputSpecifier, e);
            }
        } else {
            if (this.hasCramInput() && !this.hasReference()) {
                throw UserException.MISSING_REFERENCE_FOR_CRAM;
            }
            output = source.getParallelReads(inputSpecifier, this.referenceArguments.getReferenceSpecifier(), traversalParameters, this.bamPartitionSplitSize, this.useNio);
        }
        return output;
    }

    public void writeReads(JavaSparkContext ctx, String outputFile, JavaRDD<GATKRead> reads) {
        this.writeReads(ctx, outputFile, reads, this.readsHeader, true);
    }

    public void writeReads(JavaSparkContext ctx, String outputFile, JavaRDD<GATKRead> reads, SAMFileHeader header, boolean sortReadsToHeader) {
        try {
            ReadsSparkSink.writeReads(ctx, outputFile, this.hasReference() ? this.referenceArguments.getReferenceSpecifier() : null, reads, header, this.shardedOutput ? ReadsWriteFormat.SHARDED : ReadsWriteFormat.SINGLE, this.getRecommendedNumReducers(), this.shardedPartsDir, this.createOutputBamIndex, this.createOutputBamSplittingIndex, sortReadsToHeader, this.splittingIndexGranularity);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, "writing failed", (Exception)e);
        }
    }

    public int getRecommendedNumReducers() {
        if (this.numReducers != 0) {
            return this.numReducers;
        }
        long size = this.readInputs.keySet().stream().mapToLong(k -> BucketUtils.dirSize(k)).sum();
        int targetPartitionSize = this.getTargetPartitionSize();
        return 1 + MathUtils.toIntExactOrThrow(size / (long)targetPartitionSize, () -> new GATKException("getRecommendedNumReducers overflowed, size=" + size + " targetPartitionSize=" + targetPartitionSize));
    }

    public int getTargetPartitionSize() {
        return 0xA00000;
    }

    private boolean hasCramInput() {
        return this.readArguments.getReadPathSpecifiers().stream().anyMatch(IOPath::isCram);
    }

    public ReadFilter makeReadFilter() {
        return this.makeReadFilter(this.getHeaderForReads());
    }

    protected ReadFilter makeReadFilter(SAMFileHeader samFileHeader) {
        GATKReadFilterPluginDescriptor readFilterPlugin = (GATKReadFilterPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKReadFilterPluginDescriptor.class));
        return readFilterPlugin.getMergedReadFilter(samFileHeader);
    }

    public List<ReadFilter> getDefaultReadFilters() {
        return Arrays.asList(new WellformedReadFilter());
    }

    public boolean useVariantAnnotations() {
        return false;
    }

    public List<Annotation> getDefaultVariantAnnotations() {
        return Collections.emptyList();
    }

    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Collections.emptyList();
    }

    protected Set<VCFHeaderLine> getDefaultToolVCFHeaderLines() {
        if (this.addOutputVCFCommandLine) {
            return GATKVariantContextUtils.getDefaultVCFHeaderLines(this.getToolkitShortName(), this.getClass().getSimpleName(), this.getVersion(), Utils.getDateTimeForDisplay(ZonedDateTime.now()), this.getCommandLine());
        }
        return new HashSet<VCFHeaderLine>();
    }

    public Collection<Annotation> makeVariantAnnotations() {
        GATKAnnotationPluginDescriptor annotationPlugin = (GATKAnnotationPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKAnnotationPluginDescriptor.class));
        return annotationPlugin.getResolvedInstances();
    }

    protected String getReadSourceName() {
        if (this.readInputs.size() > 1) {
            throw new GATKException("Multiple ReadsDataSources specified but a single source requested by the tool");
        }
        return ((GATKPath)this.readInputs.keySet().stream().findFirst().get()).toString();
    }

    protected SAMFileHeader getHeaderForReadsInput(GATKPath inputPathSpecifier) {
        SAMFileHeader header = this.readInputs.get(inputPathSpecifier);
        if (header == null) {
            throw new GATKException(String.format("Input %s not present in tool inputs", inputPathSpecifier.getRawInputString()));
        }
        return header;
    }

    public ReferenceMultiSparkSource getReference() {
        return this.referenceSource;
    }

    public List<SimpleInterval> getIntervals() {
        return this.userIntervals;
    }

    @Override
    protected void runPipeline(JavaSparkContext sparkContext) {
        this.initializeToolInputs(sparkContext);
        this.validateSequenceDictionaries();
        this.runTool(sparkContext);
    }

    private void initializeToolInputs(JavaSparkContext sparkContext) {
        this.initializeReference();
        this.initializeReads(sparkContext);
        this.initializeFeatures();
        this.initializeIntervals();
    }

    private void initializeReads(JavaSparkContext sparkContext) {
        if (this.readArguments.getReadPathSpecifiers().isEmpty()) {
            return;
        }
        if (this.getReadInputMergingPolicy() == ReadInputMergingPolicy.doNotMerge && this.readArguments.getReadPathSpecifiers().size() != 1) {
            throw new UserException("Sorry, we only support a single reads input for for this spark tool.");
        }
        this.readInputs = new LinkedHashMap();
        this.readsSource = new ReadsSparkSource(sparkContext, this.readArguments.getReadValidationStringency());
        for (GATKPath input : this.readArguments.getReadPathSpecifiers()) {
            this.readInputs.put(input, this.readsSource.getHeader(input, this.referenceArguments.getReferenceSpecifier()));
        }
        this.readsHeader = this.createHeaderMerger().getMergedHeader();
    }

    private SamFileHeaderMerger createHeaderMerger() {
        return new SamFileHeaderMerger(GATKSparkTool.identifySortOrder(this.readInputs.values()), this.readInputs.values(), true);
    }

    static SAMFileHeader.SortOrder identifySortOrder(Collection<SAMFileHeader> headers) {
        if (headers.size() > 1) {
            return SAMFileHeader.SortOrder.unsorted;
        }
        return headers.iterator().next().getSortOrder();
    }

    private void initializeReference() {
        GATKPath referencePathSpecifier = this.referenceArguments.getReferenceSpecifier();
        if (referencePathSpecifier != null) {
            this.referenceSource = new ReferenceMultiSparkSource(referencePathSpecifier, this.getReferenceWindowFunction());
            this.referenceDictionary = this.referenceSource.getReferenceSequenceDictionary(this.readsHeader != null ? this.readsHeader.getSequenceDictionary() : null);
            if (this.referenceDictionary == null) {
                throw new UserException.MissingReferenceDictFile(referencePathSpecifier.getRawInputString());
            }
        }
    }

    void initializeFeatures() {
        this.features = new FeatureManager(this);
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    private void initializeIntervals() {
        if (this.intervalArgumentCollection.intervalsSpecified()) {
            SAMSequenceDictionary intervalDictionary = this.getBestAvailableSequenceDictionary();
            if (intervalDictionary == null) {
                throw new UserException("We require at least one input source that has a sequence dictionary (reference or reads) when intervals are specified");
            }
            this.userIntervals = this.intervalArgumentCollection.getIntervals(intervalDictionary);
        }
        this.userIntervals = this.editIntervals(this.userIntervals);
    }

    protected List<SimpleInterval> editIntervals(List<SimpleInterval> rawIntervals) {
        return rawIntervals;
    }

    protected void validateSequenceDictionaries() {
        if (this.sequenceDictionaryValidationArguments.performSequenceDictionaryValidation() && this.hasReference() && this.hasReads()) {
            if (this.hasCramInput()) {
                SequenceDictionaryUtils.validateCRAMDictionaryAgainstReference(this.referenceDictionary, this.readsHeader.getSequenceDictionary());
            } else {
                SequenceDictionaryUtils.validateDictionaries("reference", this.referenceDictionary, "reads", this.readsHeader.getSequenceDictionary());
            }
        }
    }

    protected static String addReferenceFilesForSpark(JavaSparkContext ctx, Path referencePath) {
        if (referencePath == null) {
            return null;
        }
        Path indexPath = ReferenceSequenceFileFactory.getFastaIndexFileName((Path)referencePath);
        Path dictPath = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence((Path)referencePath);
        Path gziPath = GZIIndex.resolveIndexNameForBgzipFile((Path)referencePath);
        ctx.addFile(referencePath.toUri().toString());
        if (Files.exists(indexPath, new LinkOption[0])) {
            ctx.addFile(indexPath.toUri().toString());
        }
        if (Files.exists(dictPath, new LinkOption[0])) {
            ctx.addFile(dictPath.toUri().toString());
        }
        if (Files.exists(gziPath, new LinkOption[0])) {
            ctx.addFile(gziPath.toUri().toString());
        }
        return referencePath.getFileName().toString();
    }

    protected static List<String> addVCFsForSpark(JavaSparkContext ctx, List<String> vcfFileNames) {
        for (String vcfFileName : vcfFileNames) {
            String vcfIndexFileName;
            if (vcfFileName.endsWith(".vcf")) {
                vcfIndexFileName = vcfFileName + ".idx";
            } else if (vcfFileName.endsWith(".vcf.gz")) {
                vcfIndexFileName = vcfFileName + ".tbi";
            } else {
                throw new IllegalArgumentException("Unrecognized known sites file extension. Must be .vcf or .vcf.gz");
            }
            ctx.addFile(vcfFileName);
            if (!Files.exists(IOUtils.getPath(vcfIndexFileName), new LinkOption[0])) continue;
            ctx.addFile(vcfIndexFileName);
        }
        return vcfFileNames.stream().map(name -> IOUtils.getPath(name).getFileName().toString()).collect(Collectors.toList());
    }

    protected abstract void runTool(JavaSparkContext var1);

    public static enum ReadInputMergingPolicy {
        doNotMerge,
        concatMerge;

    }
}

