/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import htsjdk.samtools.SAMSequenceDictionary;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.IntervalWalkerContext;
import org.broadinstitute.hellbender.engine.spark.SparkSharder;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class IntervalWalkerSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="whether to use the shuffle implementation or not", shortName="shuffle", fullName="shuffle", optional=true)
    public boolean shuffle = false;
    private String referenceFileName;

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 0);
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    public JavaRDD<IntervalWalkerContext> getIntervals(JavaSparkContext ctx) {
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List intervalShardBoundaries = this.getIntervals().stream().map(i -> new ShardBoundary((SimpleInterval)i, (SimpleInterval)i)).collect(Collectors.toList());
        JavaRDD<Shard<GATKRead>> shardedReads = SparkSharder.shard(ctx, this.getReads(), GATKRead.class, sequenceDictionary, intervalShardBoundaries, Integer.MAX_VALUE, this.shuffle);
        Broadcast bFeatureManager = this.features == null ? null : ctx.broadcast((Object)this.features);
        return shardedReads.map(IntervalWalkerSpark.getIntervalsFunction(this.referenceFileName, (Broadcast<FeatureManager>)bFeatureManager));
    }

    private static Function<Shard<GATKRead>, IntervalWalkerContext> getIntervalsFunction(String referenceFileName, Broadcast<FeatureManager> bFeatureManager) {
        return (Function & Serializable)shard -> {
            SimpleInterval interval = shard.getInterval();
            ReadsContext readsContext = new ReadsContext(new GATKDataSource<GATKRead>(){

                @Override
                public Iterator<GATKRead> iterator() {
                    return shard.iterator();
                }

                @Override
                public Iterator<GATKRead> query(SimpleInterval interval) {
                    return StreamSupport.stream(shard.spliterator(), false).filter(r -> IntervalUtils.overlaps(r, interval)).iterator();
                }
            }, shard.getInterval());
            ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            return new IntervalWalkerContext(interval, readsContext, new ReferenceContext(reference, interval), new FeatureContext(features, interval));
        };
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.referenceFileName = IntervalWalkerSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        this.processIntervals(this.getIntervals(ctx), ctx);
    }

    protected abstract void processIntervals(JavaRDD<IntervalWalkerContext> var1, JavaSparkContext var2);
}

