/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.Partition;
import org.apache.spark.rdd.PartitionCoalescer;
import org.apache.spark.rdd.PartitionGroup;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.Serializable;
import scala.collection.JavaConversions;
import scala.collection.Seq;

class RangePartitionCoalescer
implements PartitionCoalescer,
java.io.Serializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Integer> maxEndPartitionIndexes;

    public RangePartitionCoalescer(List<Integer> maxEndPartitionIndexes) {
        this.maxEndPartitionIndexes = maxEndPartitionIndexes;
    }

    public PartitionGroup[] coalesce(int maxPartitions, RDD<?> parent) {
        if (maxPartitions != parent.getNumPartitions()) {
            throw new IllegalArgumentException("Cannot use " + this.getClass().getSimpleName() + " with a different number of partitions to the parent RDD.");
        }
        List<Partition> partitions = Arrays.asList(parent.getPartitions());
        PartitionGroup[] groups = new PartitionGroup[partitions.size()];
        for (int i = 0; i < partitions.size(); ++i) {
            Seq preferredLocations = parent.getPreferredLocations(partitions.get(i));
            Option preferredLocation = Option.apply(preferredLocations.isEmpty() ? null : (String)preferredLocations.apply(0));
            PartitionGroup group = new PartitionGroup(preferredLocation);
            List<Partition> partitionsInGroup = partitions.subList(i, this.maxEndPartitionIndexes.get(i) + 1);
            group.partitions().append((Seq)JavaConversions.asScalaBuffer(partitionsInGroup));
            groups[i] = group;
        }
        return groups;
    }
}

