/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.ReadWalkerContext;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class ReadWalkerSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final int FEATURE_CACHE_LOOKAHEAD = 1000;
    private String referenceFileName;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 1000);
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    public JavaRDD<ReadWalkerContext> getReads(JavaSparkContext ctx) {
        Broadcast bFeatureManager = this.features == null ? null : ctx.broadcast((Object)this.features);
        return this.getReads().mapPartitions(ReadWalkerSpark.getReadsFunction(this.referenceFileName, (Broadcast<FeatureManager>)bFeatureManager));
    }

    private static FlatMapFunction<Iterator<GATKRead>, ReadWalkerContext> getReadsFunction(String referenceFileName, Broadcast<FeatureManager> bFeatureManager) {
        return (FlatMapFunction & Serializable)readIterator -> {
            final ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            final FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            return Iterators.transform((Iterator)readIterator, (Function)new Function<GATKRead, ReadWalkerContext>(){

                @Nullable
                public ReadWalkerContext apply(@Nullable GATKRead r) {
                    SimpleInterval readInterval = ReadWalkerSpark.getReadInterval(r);
                    return new ReadWalkerContext(r, new ReferenceContext(reference, readInterval), new FeatureContext(features, readInterval));
                }
            });
        };
    }

    static SimpleInterval getReadInterval(GATKRead read) {
        return !read.isUnmapped() && SimpleInterval.isValid(read.getContig(), read.getStart(), read.getEnd()) ? new SimpleInterval(read) : null;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.referenceFileName = ReadWalkerSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        this.processReads(this.getReads(ctx), ctx);
    }

    protected abstract void processReads(JavaRDD<ReadWalkerContext> var1, JavaSparkContext var2);
}

