/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordSparkCodec;
import java.io.InputStream;
import java.io.OutputStream;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public final class SAMRecordToGATKReadAdapterSerializer
extends Serializer<SAMRecordToGATKReadAdapter> {
    private SAMRecordSparkCodec lazyCodec = new SAMRecordSparkCodec();

    public void write(Kryo kryo, Output output, SAMRecordToGATKReadAdapter adapter) {
        SAMRecord record = adapter.getEncapsulatedSamRecord();
        record.setHeaderStrict(null);
        output.writeString(record.getReferenceName());
        output.writeString(record.getMateReferenceName());
        this.lazyCodec.setOutputStream((OutputStream)output);
        this.lazyCodec.encode(record);
        record.setFlags(record.getFlags());
    }

    public SAMRecordToGATKReadAdapter read(Kryo kryo, Input input, Class<SAMRecordToGATKReadAdapter> type) {
        String referenceName = input.readString();
        String mateReferenceName = input.readString();
        this.lazyCodec.setInputStream((InputStream)input);
        SAMRecord record = this.lazyCodec.decode();
        record.setFlags(record.getFlags());
        record.setReferenceName(referenceName);
        record.setMateReferenceName(mateReferenceName);
        return SAMRecordToGATKReadAdapter.headerlessReadAdapter(record);
    }
}

