/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.spark.SparkContextFactory;
import org.broadinstitute.hellbender.utils.Utils;

public final class SparkCommandLineArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPARK_MASTER_LONG_NAME = "spark-master";
    public static final String SPARK_VERBOSITY_LONG_NAME = "spark-verbosity";
    @Argument(doc="URL of the Spark Master to submit jobs to when using the Spark pipeline runner.", fullName="spark-master", optional=true)
    private String sparkMaster = SparkContextFactory.DEFAULT_SPARK_MASTER;
    @Argument(doc="Spark properties to set on the Spark context in the format <property>=<value>", fullName="conf", optional=true)
    final List<String> sparkProperties = new ArrayList<String>();
    @Argument(doc="Spark verbosity. Overrides --verbosity for Spark-generated logs only. Possible values: {ALL, DEBUG, INFO, WARN, ERROR, FATAL, OFF, TRACE}", fullName="spark-verbosity", optional=true)
    private String sparkVerbosity = null;

    public Map<String, String> getSparkProperties() {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
        for (String property : this.sparkProperties) {
            String[] splits = property.split("=");
            if (splits.length != 2 || splits[0].isEmpty() || splits[1].isEmpty()) {
                throw new CommandLineException.BadArgumentValue("conf", property, "Expected a value of the form spark.property.name=value");
            }
            propertyMap.put(splits[0], splits[1]);
        }
        return propertyMap;
    }

    public String getSparkMaster() {
        return this.sparkMaster;
    }

    public String getSparkVerbosity(Log.LogLevel toolVerbosity) {
        Utils.nonNull(toolVerbosity, "Tool verbosity cannot be null");
        if (this.sparkVerbosity != null) {
            return this.sparkVerbosity;
        }
        if (toolVerbosity.equals((Object)Log.LogLevel.DEBUG)) {
            return Level.DEBUG.name();
        }
        if (toolVerbosity.equals((Object)Log.LogLevel.INFO)) {
            return Level.INFO.name();
        }
        if (toolVerbosity.equals((Object)Log.LogLevel.WARNING)) {
            return Level.WARN.name();
        }
        if (toolVerbosity.equals((Object)Log.LogLevel.ERROR)) {
            return Level.ERROR.name();
        }
        throw new IllegalStateException("Unknown tool verbosity: " + toolVerbosity.name());
    }

    @VisibleForTesting
    public void setSparkVerbosity(String level) {
        this.sparkVerbosity = level;
    }
}

