/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.engine.spark.SparkCommandLineArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.SparkContextFactory;

public abstract class SparkCommandLineProgram
extends CommandLineProgram
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPARK_PROGRAM_NAME_LONG_NAME = "program-name";
    @Argument(doc="Name of the program running", fullName="program-name", optional=true)
    public String programName;
    @ArgumentCollection
    public SparkCommandLineArgumentCollection sparkArgs = new SparkCommandLineArgumentCollection();

    @Override
    protected Object doWork() {
        JavaSparkContext ctx = SparkContextFactory.getSparkContext(this.getProgramName(), this.sparkArgs.getSparkProperties(), this.sparkArgs.getSparkMaster());
        this.setSparkVerbosity(ctx);
        try {
            this.runPipeline(ctx);
            Object var2_2 = null;
            return var2_2;
        }
        finally {
            this.afterPipeline(ctx);
        }
    }

    private final void setSparkVerbosity(JavaSparkContext ctx) {
        String sparkVerbosity = this.sparkArgs.getSparkVerbosity(this.VERBOSITY);
        this.logger.info("Spark verbosity set to " + sparkVerbosity + " (see --" + "spark-verbosity" + " argument)");
        ctx.setLogLevel(sparkVerbosity);
    }

    protected abstract void runPipeline(JavaSparkContext var1);

    protected void afterPipeline(JavaSparkContext ctx) {
        SparkContextFactory.stopSparkContext(ctx);
    }

    protected String getProgramName() {
        return this.programName == null ? this.getClass().getSimpleName() : this.programName;
    }
}

