/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.serializer.KryoSerializer;
import org.broadinstitute.hellbender.engine.spark.GATKRegistrator;
import org.broadinstitute.hellbender.engine.spark.NonChecksumLocalFileSystem;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;

public final class SparkContextFactory {
    public static final String DEFAULT_SPARK_MASTER = SparkContextFactory.determineDefaultSparkMaster();
    private static final boolean SPARK_DEBUG_ENABLED = Boolean.getBoolean("gatk.spark.debug");
    private static final String SPARK_CORES_ENV_VARIABLE = "GATK_TEST_SPARK_CORES";
    private static final String TEST_PROJECT_ENV_VARIABLE = "HELLBENDER_TEST_PROJECT";
    private static final String TEST_JSON_KEYFILE_ENV_VARIABLE = "HELLBENDER_JSON_SERVICE_ACCOUNT_KEY";
    private static final Logger logger = LogManager.getLogger(SparkContextFactory.class);
    public static final Map<String, String> MANDATORY_PROPERTIES = ImmutableMap.builder().put((Object)"spark.serializer", (Object)KryoSerializer.class.getCanonicalName()).put((Object)"spark.kryo.registrator", (Object)GATKRegistrator.class.getCanonicalName()).put((Object)"spark.hadoop.fs.file.impl", (Object)NonChecksumLocalFileSystem.class.getCanonicalName()).build();
    public static final Map<String, String> DEFAULT_PROPERTIES = ImmutableMap.builder().put((Object)"spark.kryoserializer.buffer.max", (Object)"512m").put((Object)"spark.driver.maxResultSize", (Object)"0").put((Object)"spark.driver.userClassPathFirst", (Object)"true").put((Object)"spark.io.compression.codec", (Object)"lzf").put((Object)"spark.executor.memoryOverhead", (Object)"600").build();
    private static boolean testContextEnabled;
    private static JavaSparkContext testContext;

    private static ImmutableMap<String, String> getDefaultTestProperties() {
        return ImmutableMap.builder().put((Object)"spark.ui.enabled", (Object)Boolean.toString(SPARK_DEBUG_ENABLED)).put((Object)"spark.kryoserializer.buffer.max", (Object)"256m").put((Object)"spark.hadoop.fs.file.impl.disable.cache", (Object)"true").putAll(SparkContextFactory.getGcsHadoopAdapterTestProperties()).build();
    }

    private static Map<String, String> getGcsHadoopAdapterTestProperties() {
        String testProject = System.getenv(TEST_PROJECT_ENV_VARIABLE);
        String testKeyFile = System.getenv(TEST_JSON_KEYFILE_ENV_VARIABLE);
        if (testProject == null || testKeyFile == null) {
            logger.warn("Environment variables HELLBENDER_TEST_PROJECT and HELLBENDER_JSON_SERVICE_ACCOUNT_KEY must be set or the GCS hadoop connector will not be configured properly");
            return Collections.emptyMap();
        }
        return ImmutableMap.builder().put((Object)"spark.hadoop.fs.gs.impl", (Object)"com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem").put((Object)"spark.hadoop.fs.AbstractFileSystem.gs.impl", (Object)"com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS").put((Object)"spark.hadoop.fs.gs.project.id", (Object)testProject).put((Object)"spark.hadoop.google.cloud.auth.service.account.json.keyfile", (Object)testKeyFile).build();
    }

    private SparkContextFactory() {
    }

    public static synchronized void enableTestSparkContext() {
        testContextEnabled = true;
    }

    public static synchronized JavaSparkContext getSparkContext(String appName, Map<String, String> overridingProperties, String master) {
        if (testContextEnabled) {
            JavaSparkContext context = SparkContextFactory.getTestSparkContext(overridingProperties);
            Utils.validateArg(master.equals(context.master()), () -> String.format("Cannot reuse spark context with different spark master URL. Existing: %s, requested: %s.", context.master(), master));
            return context;
        }
        return SparkContextFactory.createSparkContext(appName, overridingProperties, master);
    }

    public static synchronized JavaSparkContext getTestSparkContext() {
        return SparkContextFactory.getTestSparkContext(Collections.emptyMap());
    }

    public static synchronized JavaSparkContext getTestSparkContext(Map<String, String> overridingProperties) {
        if (testContextEnabled && testContext == null) {
            testContext = SparkContextFactory.createTestSparkContext(overridingProperties);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    testContext.stop();
                }
            });
        }
        return testContext;
    }

    public static synchronized void stopSparkContext(JavaSparkContext context) {
        if (context != testContext) {
            context.stop();
        }
    }

    @VisibleForTesting
    static SparkConf setupSparkConf(String appName, String master, Map<String, String> suggestedProperties, Map<String, String> overridingProperties) {
        SparkConf sparkConf = new SparkConf().setAppName(appName).setMaster(master);
        suggestedProperties.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).setIfMissing(arg_0, arg_1));
        MANDATORY_PROPERTIES.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
        overridingProperties.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
        return sparkConf;
    }

    private static JavaSparkContext createSparkContext(String appName, Map<String, String> overridingProperties, String master) {
        SparkConf sparkConf = SparkContextFactory.setupSparkConf(appName, master, DEFAULT_PROPERTIES, overridingProperties);
        return new JavaSparkContext(sparkConf);
    }

    private static JavaSparkContext createTestSparkContext(Map<String, String> overridingProperties) {
        SparkConf sparkConf = SparkContextFactory.setupSparkConf("TestContext", DEFAULT_SPARK_MASTER, SparkContextFactory.getDefaultTestProperties(), overridingProperties);
        return new JavaSparkContext(sparkConf);
    }

    private static String determineDefaultSparkMaster() {
        String sparkMasterString;
        String defaultSparkMasterString = "local[*]";
        String sparkSpecFromEnvironment = System.getenv(SPARK_CORES_ENV_VARIABLE);
        if (null == sparkSpecFromEnvironment) {
            sparkMasterString = "local[*]";
        } else {
            int numSparkCoresFromEnv = 0;
            try {
                numSparkCoresFromEnv = Integer.parseInt(sparkSpecFromEnvironment);
            }
            catch (NumberFormatException e) {
                throw new UserException("Illegal number of cores specified in GATK_TEST_SPARK_CORES. Positive integers only");
            }
            if (numSparkCoresFromEnv > 0) {
                sparkMasterString = String.format("local[%d]", numSparkCoresFromEnv);
            } else {
                throw new UserException("Illegal number of cores specified in GATK_TEST_SPARK_CORES. Number of cores must be positive");
            }
        }
        return sparkMasterString;
    }
}

