/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.SparkSharder;
import org.broadinstitute.hellbender.engine.spark.VariantWalkerContext;
import org.broadinstitute.hellbender.engine.spark.datasources.VariantsSparkSource;
import org.broadinstitute.hellbender.utils.IndexUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public abstract class VariantWalkerSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="variant", shortName="V", doc="A VCF file containing variants", common=false, optional=false)
    public String drivingVariantFile;
    @Argument(fullName="variantShardSize", shortName="variantShardSize", doc="Maximum size of each variant shard, in bases.", optional=true)
    public int variantShardSize = 10000;
    @Argument(doc="whether to use the shuffle implementation or not", shortName="shuffle", fullName="shuffle", optional=true)
    public boolean shuffle = false;
    private String referenceFileName;
    private transient VariantsSparkSource variantsSource;
    public static final int FEATURE_CACHE_LOOKAHEAD = 100000;

    @Override
    protected void runPipeline(JavaSparkContext sparkContext) {
        this.initializeVariants(sparkContext);
        super.runPipeline(sparkContext);
    }

    void initializeVariants(JavaSparkContext sparkContext) {
        this.variantsSource = new VariantsSparkSource(sparkContext);
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 100000);
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    @Override
    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        SAMSequenceDictionary dictFromDrivingVariants = this.getHeaderForVariants().getSequenceDictionary();
        if (dictFromDrivingVariants != null) {
            if (IndexUtils.isSequenceDictionaryFromIndex(dictFromDrivingVariants)) {
                SAMSequenceDictionary otherDictionary = super.getBestAvailableSequenceDictionary();
                return otherDictionary != null ? otherDictionary : dictFromDrivingVariants;
            }
            return dictFromDrivingVariants;
        }
        return super.getBestAvailableSequenceDictionary();
    }

    public final VCFHeader getHeaderForVariants() {
        return VariantsSparkSource.getHeader(this.drivingVariantFile);
    }

    protected VariantFilter makeVariantFilter() {
        return VariantFilterLibrary.ALLOW_ALL_VARIANTS;
    }

    public JavaRDD<VariantWalkerContext> getVariants(JavaSparkContext ctx) {
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<SimpleInterval> intervals = this.hasUserSuppliedIntervals() ? this.getIntervals() : IntervalUtils.getAllIntervalsForReference(sequenceDictionary);
        List intervalShards = intervals.stream().flatMap(interval -> Shard.divideIntervalIntoShards(interval, this.variantShardSize, 0, sequenceDictionary).stream()).collect(Collectors.toList());
        JavaRDD variants = this.variantsSource.getParallelVariantContexts(this.drivingVariantFile, this.getIntervals());
        VariantFilter variantFilter = this.makeVariantFilter();
        variants = variants.filter(variantFilter::test);
        JavaRDD<Shard<VariantContext>> shardedVariants = SparkSharder.shard(ctx, variants, VariantContext.class, sequenceDictionary, intervalShards, this.variantShardSize, this.shuffle);
        Broadcast bFeatureManager = this.features == null ? null : ctx.broadcast((Object)this.features);
        return shardedVariants.flatMap(VariantWalkerSpark.getVariantsFunction(this.referenceFileName, (Broadcast<FeatureManager>)bFeatureManager));
    }

    private static FlatMapFunction<Shard<VariantContext>, VariantWalkerContext> getVariantsFunction(String referenceFileName, Broadcast<FeatureManager> bFeatureManager) {
        return (FlatMapFunction & Serializable)shard -> {
            ReferenceFileSource reference = referenceFileName == null ? null : new ReferenceFileSource(IOUtils.getPath(SparkFiles.get((String)referenceFileName)));
            FeatureManager features = bFeatureManager == null ? null : (FeatureManager)bFeatureManager.getValue();
            return StreamSupport.stream(shard.spliterator(), false).filter(v -> v.getStart() >= shard.getStart() && v.getStart() <= shard.getEnd()).map(v -> {
                SimpleInterval variantInterval = new SimpleInterval((Locatable)v);
                return new VariantWalkerContext((VariantContext)v, new ReadsContext(), new ReferenceContext(reference, variantInterval), new FeatureContext(features, variantInterval));
            }).iterator();
        };
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.referenceFileName = VariantWalkerSpark.addReferenceFilesForSpark(ctx, this.referenceArguments.getReferencePath());
        this.processVariants(this.getVariants(ctx), ctx);
    }

    protected abstract void processVariants(JavaRDD<VariantWalkerContext> var1, JavaSparkContext var2);
}

