/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.avro.AvroParquetInputFormat;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsPathDataSource;
import org.broadinstitute.hellbender.engine.TraversalParameters;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceTwoBitSparkSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.BDGAlignmentRecordToGATKReadAdapter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadConstants;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;
import org.broadinstitute.hellbender.utils.spark.SparkUtils;
import org.disq_bio.disq.HtsjdkReadsRdd;
import org.disq_bio.disq.HtsjdkReadsRddStorage;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;

public final class ReadsSparkSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient JavaSparkContext ctx;
    private ValidationStringency validationStringency = ReadConstants.DEFAULT_READ_VALIDATION_STRINGENCY;

    public ReadsSparkSource(JavaSparkContext ctx) {
        this.ctx = ctx;
    }

    public ReadsSparkSource(JavaSparkContext ctx, ValidationStringency validationStringency) {
        this.ctx = ctx;
        this.validationStringency = validationStringency;
    }

    public JavaRDD<GATKRead> getParallelReads(GATKPath readsPathSpecifier, GATKPath referencePathSpecifier, TraversalParameters traversalParameters) {
        return this.getParallelReads(readsPathSpecifier, referencePathSpecifier, traversalParameters, 0L);
    }

    public JavaRDD<GATKRead> getParallelReads(GATKPath readsPathSpecifier, GATKPath referencePathSpecifier, TraversalParameters traversalParameters, long splitSize) {
        return this.getParallelReads(readsPathSpecifier, referencePathSpecifier, traversalParameters, splitSize, false);
    }

    public JavaRDD<GATKRead> getParallelReads(GATKPath readPathSpecifier, GATKPath referencePathSpecifier, TraversalParameters traversalParameters, long splitSize, boolean useNio) {
        try {
            GATKPath cramReferencePathSpec = ReadsSparkSource.checkCramReference(this.ctx, readPathSpecifier, referencePathSpecifier);
            HtsjdkReadsTraversalParameters tp = traversalParameters == null ? null : new HtsjdkReadsTraversalParameters(traversalParameters.getIntervalsForTraversal(), traversalParameters.traverseUnmappedReads());
            HtsjdkReadsRdd htsjdkReadsRdd = HtsjdkReadsRddStorage.makeDefault((JavaSparkContext)this.ctx).useNio(useNio).splitSize((int)splitSize).validationStringency(this.validationStringency).referenceSourcePath(cramReferencePathSpec == null ? null : cramReferencePathSpec.getRawInputString()).read(readPathSpecifier.getRawInputString(), tp);
            JavaRDD reads = htsjdkReadsRdd.getReads().map((Function & Serializable)read -> SAMRecordToGATKReadAdapter.headerlessReadAdapter(read)).filter(Objects::nonNull);
            return ReadsSparkSource.fixPartitionsIfQueryGrouped(this.ctx, htsjdkReadsRdd.getHeader(), (JavaRDD<GATKRead>)reads);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UserException("Failed to load reads from " + readPathSpecifier.getRawInputString() + "\n Caused by:" + e.getMessage(), e);
        }
    }

    private static JavaRDD<GATKRead> fixPartitionsIfQueryGrouped(JavaSparkContext ctx, SAMFileHeader header, JavaRDD<GATKRead> reads) {
        if (ReadUtils.isReadNameGroupedBam(header)) {
            return SparkUtils.putReadsWithTheSameNameInTheSamePartition(header, reads, ctx);
        }
        return reads;
    }

    public JavaRDD<GATKRead> getParallelReads(GATKPath readsPathSpecifier, GATKPath referencePathSpecifier) {
        return this.getParallelReads(readsPathSpecifier, referencePathSpecifier, 0);
    }

    public JavaRDD<GATKRead> getParallelReads(GATKPath readsPathSpecifier, GATKPath referencePathSpecifier, int splitSize) {
        return this.getParallelReads(readsPathSpecifier, referencePathSpecifier, null, splitSize);
    }

    public JavaRDD<GATKRead> getADAMReads(GATKPath inputPathSpecifier, TraversalParameters traversalParameters, SAMFileHeader header) throws IOException {
        Job job = Job.getInstance((Configuration)this.ctx.hadoopConfiguration());
        AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)AlignmentRecord.getClassSchema());
        Broadcast bHeader = header == null ? this.ctx.broadcast(null) : this.ctx.broadcast((Object)header);
        JavaRDD recordsRdd = this.ctx.newAPIHadoopFile(inputPathSpecifier.getRawInputString(), AvroParquetInputFormat.class, Void.class, AlignmentRecord.class, job.getConfiguration()).values();
        JavaRDD readsRdd = recordsRdd.map((Function & Serializable)record -> new BDGAlignmentRecordToGATKReadAdapter((AlignmentRecord)record, (SAMFileHeader)bHeader.getValue()));
        JavaRDD filteredRdd = readsRdd.filter((Function & Serializable)record -> ReadsSparkSource.samRecordOverlaps(record.convertToSAMRecord(header), traversalParameters));
        return ReadsSparkSource.fixPartitionsIfQueryGrouped(this.ctx, header, (JavaRDD<GATKRead>)filteredRdd);
    }

    public SAMFileHeader getHeader(GATKPath filePathSpecifier, GATKPath referencePathSpecifier) {
        GATKPath cramReferencePathSpec = ReadsSparkSource.checkCramReference(this.ctx, filePathSpecifier, referencePathSpecifier);
        if (BucketUtils.isGcsUrl(filePathSpecifier)) {
            SamReaderFactory factory = SamReaderFactory.makeDefault().validationStringency(this.validationStringency).referenceSequence(cramReferencePathSpec == null ? null : referencePathSpecifier.toPath());
            try (ReadsPathDataSource readsDataSource = new ReadsPathDataSource(Collections.singletonList(filePathSpecifier.toPath()), factory);){
                SAMFileHeader sAMFileHeader = readsDataSource.getHeader();
                return sAMFileHeader;
            }
        }
        try {
            return HtsjdkReadsRddStorage.makeDefault((JavaSparkContext)this.ctx).validationStringency(this.validationStringency).referenceSourcePath(cramReferencePathSpec == null ? null : cramReferencePathSpec.getRawInputString()).read(filePathSpecifier.getRawInputString()).getHeader();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UserException("Failed to read bam header from " + filePathSpecifier.getRawInputString() + "\n Caused by:" + e.getMessage(), e);
        }
    }

    static GATKPath checkCramReference(JavaSparkContext ctx, GATKPath filePathSpecifier, GATKPath referencePathSpecifier) {
        if (filePathSpecifier.isCram()) {
            Path nioReferencePath;
            if (referencePathSpecifier == null) {
                throw new UserException.MissingReference("A reference is required for CRAM input");
            }
            if (ReferenceTwoBitSparkSource.isTwoBit(referencePathSpecifier)) {
                throw new UserException("A 2bit file cannot be used as a CRAM file reference");
            }
            if (referencePathSpecifier.isHadoopURL() ? !SparkUtils.hadoopPathExists(ctx, referencePathSpecifier.getURI()) : !Files.exists(nioReferencePath = referencePathSpecifier.toPath(), new LinkOption[0])) {
                throw new UserException.MissingReference("The specified fasta file (" + referencePathSpecifier + ") does not exist.");
            }
            return referencePathSpecifier;
        }
        return null;
    }

    private static boolean samRecordOverlaps(SAMRecord record, TraversalParameters traversalParameters) {
        if (traversalParameters == null) {
            return true;
        }
        if (traversalParameters.traverseUnmappedReads() && record.getReadUnmappedFlag() && record.getAlignmentStart() == 0) {
            return true;
        }
        List<SimpleInterval> intervals = traversalParameters.getIntervalsForTraversal();
        if (intervals == null || intervals.isEmpty()) {
            return false;
        }
        for (SimpleInterval interval : intervals) {
            if (record.getReadUnmappedFlag() && record.getAlignmentStart() != 0) {
                int start = record.getAlignmentStart();
                return interval.getStart() <= start && interval.getEnd() >= start;
            }
            if (!interval.overlaps((Locatable)record)) continue;
            return true;
        }
        return false;
    }
}

