/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceSparkSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public class ReferenceFileSparkSource
implements ReferenceSparkSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URI referenceUri;
    private transient Path referencePath;

    public ReferenceFileSparkSource(GATKPath referenceSpecifier) {
        this.referencePath = referenceSpecifier.toPath();
        this.referenceUri = this.referencePath.toUri();
        if (!Files.exists(this.referencePath, new LinkOption[0])) {
            throw new UserException.MissingReference("The specified fasta file (" + referenceSpecifier.getRawInputString() + ") does not exist.");
        }
    }

    private synchronized Path getReferencePath() {
        if (null == this.referencePath) {
            this.referencePath = new GATKPath(this.referenceUri.toString()).toPath();
        }
        return this.referencePath;
    }

    @Override
    public ReferenceBases getReferenceBases(SimpleInterval interval) throws IOException {
        try (ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)this.getReferencePath());){
            ReferenceSequence sequence = referenceSequenceFile.getSubsequenceAt(interval.getContig(), (long)interval.getStart(), (long)interval.getEnd());
            ReferenceBases referenceBases = new ReferenceBases(sequence.getBases(), interval);
            return referenceBases;
        }
    }

    public Map<String, ReferenceBases> getAllReferenceBases() throws IOException {
        try (ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)this.getReferencePath());){
            ReferenceSequence seq;
            LinkedHashMap<String, ReferenceBases> bases = new LinkedHashMap<String, ReferenceBases>();
            while ((seq = referenceSequenceFile.nextSequence()) != null) {
                String name = seq.getName();
                bases.put(name, new ReferenceBases(seq.getBases(), new SimpleInterval(name, 1, seq.length())));
            }
            LinkedHashMap<String, ReferenceBases> linkedHashMap = bases;
            return linkedHashMap;
        }
    }

    @Override
    public SAMSequenceDictionary getReferenceSequenceDictionary(SAMSequenceDictionary optReadSequenceDictionaryToMatch) throws IOException {
        try (ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)this.getReferencePath());){
            SAMSequenceDictionary sAMSequenceDictionary = referenceSequenceFile.getSequenceDictionary();
            return sAMSequenceDictionary;
        }
    }
}

