/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceSparkSource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public class ReferenceHadoopSparkSource
implements ReferenceSparkSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URI referenceURI;

    public ReferenceHadoopSparkSource(GATKPath referencePathSpecifier) {
        this.referenceURI = referencePathSpecifier.getURI();
    }

    @Override
    public ReferenceBases getReferenceBases(SimpleInterval interval) {
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)new GATKPath(this.referenceURI.toString()).toPath());
        ReferenceSequence sequence = referenceSequenceFile.getSubsequenceAt(interval.getContig(), (long)interval.getStart(), (long)interval.getEnd());
        return new ReferenceBases(sequence.getBases(), interval);
    }

    @Override
    public SAMSequenceDictionary getReferenceSequenceDictionary(SAMSequenceDictionary optReadSequenceDictionaryToMatch) {
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)new GATKPath(this.referenceURI.toString()).toPath());
        return referenceSequenceFile.getSequenceDictionary();
    }
}

