/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.FileExtensions;
import java.io.IOException;
import java.io.Serializable;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceFileSparkSource;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceHadoopSparkSource;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceSparkSource;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceTwoBitSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SerializableFunction;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public class ReferenceMultiSparkSource
implements ReferenceSparkSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private ReferenceSparkSource referenceSource;
    private SerializableFunction<GATKRead, SimpleInterval> referenceWindowFunction;

    @VisibleForTesting
    protected ReferenceMultiSparkSource() {
    }

    public ReferenceMultiSparkSource(GATKPath referencePathSpecifier, SerializableFunction<GATKRead, SimpleInterval> referenceWindowFunction) {
        Utils.nonNull(referenceWindowFunction);
        if (ReferenceTwoBitSparkSource.isTwoBit(referencePathSpecifier)) {
            try {
                this.referenceSource = new ReferenceTwoBitSparkSource(referencePathSpecifier);
            }
            catch (IOException e) {
                throw new UserException("Failed to create a ReferenceTwoBitSource object" + e.getMessage());
            }
        } else if (referencePathSpecifier.isFasta()) {
            this.referenceSource = referencePathSpecifier.isHadoopURL() ? new ReferenceHadoopSparkSource(referencePathSpecifier) : new ReferenceFileSparkSource(referencePathSpecifier);
        } else {
            throw new UserException.CouldNotReadInputFile("Couldn't read the given reference, reference must be a .fasta or .2bit file.\n Reference provided was: " + referencePathSpecifier);
        }
        this.referenceWindowFunction = referenceWindowFunction;
    }

    static boolean isFasta(GATKPath referencePathSpecifier) {
        String referencePathString = referencePathSpecifier.getURI().getPath();
        for (String ext : FileExtensions.FASTA) {
            if (!referencePathString.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public SerializableFunction<GATKRead, SimpleInterval> getReferenceWindowFunction() {
        return this.referenceWindowFunction;
    }

    @Override
    public ReferenceBases getReferenceBases(SimpleInterval interval) throws IOException {
        return this.referenceSource.getReferenceBases(interval);
    }

    @Override
    public SAMSequenceDictionary getReferenceSequenceDictionary(SAMSequenceDictionary optReadSequenceDictionaryToMatch) {
        try {
            return this.referenceSource.getReferenceSequenceDictionary(optReadSequenceDictionaryToMatch);
        }
        catch (IOException e) {
            throw new GATKException("Error getting reference sequence dictionary");
        }
    }
}

