/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import com.google.common.io.ByteStreams;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.util.TwoBitFile;
import org.bdgenomics.adam.util.TwoBitRecord;
import org.bdgenomics.formats.avro.Strand;
import org.bdgenomics.utils.io.ByteAccess;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.spark.datasources.DirectFullByteArrayByteAccess;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceSparkSource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ReferenceTwoBitSparkSource
implements ReferenceSparkSource,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TWO_BIT_EXTENSION = ".2bit";
    private final String referenceURL;
    private final TwoBitFile twoBitFile;
    private final Map<String, TwoBitRecord> twoBitSeqEntries;

    public ReferenceTwoBitSparkSource(GATKPath referencePathSpecifier) throws IOException {
        this.referenceURL = referencePathSpecifier.getRawInputString();
        Utils.validateArg(ReferenceTwoBitSparkSource.isTwoBit(referencePathSpecifier), "ReferenceTwoBitSource can only take .2bit files");
        byte[] bytes = ByteStreams.toByteArray((InputStream)BucketUtils.openFile(this.referenceURL));
        DirectFullByteArrayByteAccess byteAccess = new DirectFullByteArrayByteAccess(bytes);
        this.twoBitFile = new TwoBitFile((ByteAccess)byteAccess);
        this.twoBitSeqEntries = new LinkedHashMap<String, TwoBitRecord>();
        for (Tuple2 pair : JavaConversions.seqAsJavaList((Seq)this.twoBitFile.seqRecords())) {
            this.twoBitSeqEntries.put((String)pair._1, (TwoBitRecord)pair._2);
        }
    }

    @Override
    public ReferenceBases getReferenceBases(SimpleInterval interval) throws IOException {
        SimpleInterval queryInterval = this.cropIntervalAtContigEnd(interval);
        String bases = this.twoBitFile.extract(ReferenceTwoBitSparkSource.simpleIntervalToReferenceRegion(queryInterval));
        return new ReferenceBases(bases.getBytes(), queryInterval);
    }

    @Override
    public SAMSequenceDictionary getReferenceSequenceDictionary(SAMSequenceDictionary optReadSequenceDictionaryToMatch) throws IOException {
        List records = this.twoBitSeqEntries.entrySet().stream().map(pair -> new SAMSequenceRecord((String)pair.getKey(), ((TwoBitRecord)pair.getValue()).dnaSize())).collect(Collectors.toList());
        return new SAMSequenceDictionary(records);
    }

    public static boolean isTwoBit(GATKPath referenceSpecifier) {
        return referenceSpecifier.getURI().getPath().endsWith(TWO_BIT_EXTENSION);
    }

    private static ReferenceRegion simpleIntervalToReferenceRegion(SimpleInterval interval) {
        String contig = interval.getContig();
        long start = interval.getGA4GHStart();
        long end = interval.getGA4GHEnd();
        return new ReferenceRegion(contig, start, end, Strand.UNKNOWN);
    }

    private SimpleInterval cropIntervalAtContigEnd(SimpleInterval interval) {
        TwoBitRecord contigRecord = this.twoBitSeqEntries.get(interval.getContig());
        Utils.nonNull(contigRecord, () -> "Contig " + interval.getContig() + " not found in reference dictionary");
        return new SimpleInterval(interval.getContig(), interval.getStart(), Math.min(interval.getEnd(), contigRecord.dnaSize()));
    }
}

