/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import org.broadinstitute.hellbender.utils.SerializableFunction;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReferenceWindowFunctions {
    public static final SerializableFunction<GATKRead, SimpleInterval> IDENTITY_FUNCTION = new SerializableFunction<GATKRead, SimpleInterval>(){
        private static final long serialVersionUID = 1L;

        @Override
        public SimpleInterval apply(GATKRead input) {
            return new SimpleInterval(input);
        }
    };

    public static final class FixedWindowFunction
    implements SerializableFunction<GATKRead, SimpleInterval> {
        private static final long serialVersionUID = 1L;
        private final int leadingWindowBases;
        private final int trailingWindowBases;

        public FixedWindowFunction(int leadingWindowBases, int trailingWindowBases) {
            this.leadingWindowBases = leadingWindowBases;
            this.trailingWindowBases = trailingWindowBases;
        }

        @Override
        public SimpleInterval apply(GATKRead read) {
            return new SimpleInterval(read.getContig(), Math.max(read.getStart() - this.leadingWindowBases, 1), read.getEnd() + this.trailingWindowBases);
        }
    }
}

