/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlockCombiner;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFBlockCombiningIterator;
import org.disq_bio.disq.HtsjdkVariantsRdd;
import org.disq_bio.disq.HtsjdkVariantsRddStorage;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.WriteOption;
import scala.Tuple2;

public final class VariantsSparkSink {
    public static void writeVariants(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header) throws IOException {
        VariantsSparkSink.writeVariants(ctx, outputFile, variants, header, false, null, 0, 0, true, true);
    }

    public static void writeVariants(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header, boolean writeTabixIndex) throws IOException {
        VariantsSparkSink.writeVariants(ctx, outputFile, variants, header, writeTabixIndex, true);
    }

    public static void writeVariants(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header, boolean writeTabixIndex, boolean sortVariantsToHeader) throws IOException {
        VariantsSparkSink.writeVariants(ctx, outputFile, variants, header, false, null, 0, 0, writeTabixIndex, sortVariantsToHeader);
    }

    public static void writeVariants(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header, boolean writeGvcf, List<Number> gqPartitions, int defaultPloidy) throws IOException {
        VariantsSparkSink.writeVariants(ctx, outputFile, variants, header, writeGvcf, gqPartitions, defaultPloidy, 0, true, true);
    }

    public static void writeVariants(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header, boolean writeGvcf, List<Number> gqPartitions, int defaultPloidy, int numReducers, boolean writeTabixIndex, boolean sortVariantsToHeader) throws IOException {
        String absoluteOutputFile = BucketUtils.makeFilePathAbsolute(outputFile);
        VariantsSparkSink.writeVariantsSingle(ctx, absoluteOutputFile, variants, header, writeGvcf, gqPartitions, defaultPloidy, numReducers, writeTabixIndex, sortVariantsToHeader);
    }

    private static void writeVariantsSingle(JavaSparkContext ctx, String outputFile, JavaRDD<VariantContext> variants, VCFHeader header, boolean writeGvcf, List<Number> gqPartitions, int defaultPloidy, int numReducers, boolean writeTabixIndex, boolean sortVariantsToHeader) throws IOException {
        JavaRDD variantsToSave;
        JavaRDD sortedVariants;
        if (outputFile.endsWith(".bcf") || outputFile.endsWith(".bcf.gz")) {
            throw new UserException.UnimplementedFeature("It is currently not possible to write a BCF file on spark.  See https://github.com/broadinstitute/gatk/issues/4303 for more details .");
        }
        Object object = sortedVariants = sortVariantsToHeader ? VariantsSparkSink.sortVariants(variants, header, numReducers) : variants;
        if (writeGvcf) {
            GVCFBlockCombiner gvcfBlockCombiner = new GVCFBlockCombiner(gqPartitions, defaultPloidy, false);
            gvcfBlockCombiner.addRangesToHeader(header);
            variantsToSave = sortedVariants.mapPartitions((FlatMapFunction & Serializable)v -> new GVCFBlockCombiningIterator((Iterator<VariantContext>)v, gqPartitions, defaultPloidy));
        } else {
            variantsToSave = sortedVariants;
        }
        TabixIndexWriteOption tabixIndexWriteOption = TabixIndexWriteOption.fromBoolean((boolean)writeTabixIndex);
        HtsjdkVariantsRdd htsjdkVariantsRdd = new HtsjdkVariantsRdd(header, variantsToSave);
        HtsjdkVariantsRddStorage.makeDefault((JavaSparkContext)ctx).write(htsjdkVariantsRdd, outputFile, new WriteOption[]{tabixIndexWriteOption});
    }

    private static JavaRDD<VariantContext> sortVariants(JavaRDD<VariantContext> variants, VCFHeader header, int numReducers) {
        JavaPairRDD rddVariantPairs = variants.mapToPair((PairFunction & Serializable)variant -> new Tuple2(variant, (Object)null));
        VariantContextComparator comparator = header.getVCFRecordComparator();
        JavaPairRDD variantVoidPairs = comparator == null ? rddVariantPairs : (numReducers > 0 ? rddVariantPairs.sortByKey((Comparator)comparator, true, numReducers) : rddVariantPairs.sortByKey((Comparator)comparator));
        return variantVoidPairs.map(Tuple2::_1);
    }
}

