/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark.datasources;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.variant.utils.VCFHeaderReader;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import org.broadinstitute.hellbender.utils.variant.VariantContextVariantAdapter;
import org.disq_bio.disq.HtsjdkVariantsRddStorage;

public final class VariantsSparkSource {
    private final JavaSparkContext ctx;

    public VariantsSparkSource(JavaSparkContext ctx) {
        this.ctx = ctx;
    }

    public JavaRDD<GATKVariant> getParallelVariants(String vcf, List<SimpleInterval> intervals) {
        return this.getParallelVariantContexts(vcf, intervals).filter((Function & Serializable)vc -> vc.getCommonInfo() != null).map((Function & Serializable)vc -> VariantContextVariantAdapter.sparkVariantAdapter(vc));
    }

    public JavaRDD<GATKVariant> getParallelVariants(List<String> vcfs, List<SimpleInterval> intervals) {
        return vcfs.parallelStream().map(vcf -> this.getParallelVariants((String)vcf, intervals)).reduce(this.ctx.emptyRDD(), (result, rdd) -> result.union(rdd));
    }

    public JavaRDD<VariantContext> getParallelVariantContexts(String vcf, List<SimpleInterval> intervals) {
        try {
            return HtsjdkVariantsRddStorage.makeDefault((JavaSparkContext)this.ctx).read(vcf, intervals).getVariants();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static VCFHeader getHeader(String filePath) {
        try {
            return VCFHeaderReader.readHeaderFrom((SeekableStream)SeekableStreamFactory.getInstance().getStreamFor(filePath));
        }
        catch (IOException e) {
            throw new UserException("Failed to read VCF header from " + filePath + "\n Caused by:" + e.getMessage(), e);
        }
    }
}

