/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.exceptions;

import htsjdk.samtools.SAMRecord;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class GATKException
extends RuntimeException {
    private static final long serialVersionUID = 0L;

    public GATKException(String msg) {
        super(msg);
    }

    public GATKException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static class ReadAttributeTypeMismatch
    extends GATKException {
        private static final long serialVersionUID = 0L;

        public ReadAttributeTypeMismatch(String attributeName, String targetType) {
            super(String.format("Attribute %s not of (or convertible to) type %s", attributeName, targetType));
        }

        public ReadAttributeTypeMismatch(String attributeName, String targetType, Throwable throwable) {
            super(String.format("Attribute %s not of (or convertible to) type %s", attributeName, targetType), throwable);
        }

        public ReadAttributeTypeMismatch(SAMRecord read, String attributeName, String targetType) {
            super(String.format("In read %s @ %s attribute %s not of (or convertible to) type %s", read.getReadName(), "" + read.getContig() + ":" + read.getStart(), attributeName, targetType));
        }

        public ReadAttributeTypeMismatch(SAMRecord read, String attributeName, String targetType, Object value) {
            super(String.format("In read %s @ %s attribute %s not of (or convertible to) type %s: class is '%s' and value is '%s'", read.getReadName(), "" + read.getContig() + ":" + read.getStart(), attributeName, targetType, value == null ? "null" : value.getClass(), "" + value));
        }

        public ReadAttributeTypeMismatch(SAMRecord read, String attributeName, String targetType, Throwable ex) {
            super(String.format("In read %s @ %s attribute %s not of (or convertible to) type %s", read.getReadName(), "" + read.getContig() + ":" + read.getStart(), attributeName, targetType, ex));
        }
    }

    public static class MissingReadField
    extends GATKException {
        private static final long serialVersionUID = 0L;

        public MissingReadField(String fieldName) {
            super(String.format("Attempted to access field \"%s\" in read, but field is not present", fieldName));
        }

        public MissingReadField(String fieldName, String message) {
            super(String.format("Attempted to access field \"%s\" in read, but field is not present. %s", fieldName, message));
        }

        public MissingReadField(String fieldName, GATKRead read) {
            super(String.format("Attempted to access field \"%s\" in read %s, but field is not present", fieldName, read));
        }
    }

    public static class ShouldNeverReachHereException
    extends GATKException {
        private static final long serialVersionUID = 0L;

        public ShouldNeverReachHereException(String s) {
            super(s);
        }

        public ShouldNeverReachHereException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public ShouldNeverReachHereException(Throwable throwable) {
            this("Should never reach here.", throwable);
        }
    }
}

