/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.metrics;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.metrics.InsertSizeMetrics;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsArgumentCollection;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsCollectorArgs;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.metrics.MultiLevelReducibleCollector;
import org.broadinstitute.hellbender.metrics.PerUnitInsertSizeMetricsCollector;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.R.RScriptExecutorException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.Resource;

public final class InsertSizeMetricsCollector
extends MultiLevelReducibleCollector<InsertSizeMetrics, Integer, InsertSizeMetricsCollectorArgs, PerUnitInsertSizeMetricsCollector>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(InsertSizeMetricsCollector.class);
    InsertSizeMetricsArgumentCollection inputArgs = null;

    public void initialize(InsertSizeMetricsArgumentCollection inputArgs, SAMFileHeader samHeader) {
        Utils.nonNull(inputArgs);
        Utils.nonNull(samHeader);
        this.inputArgs = inputArgs;
        this.setup(inputArgs.metricAccumulationLevel.accumulationLevels, samHeader.getReadGroups());
    }

    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>();
        readFilters.add(new WellformedReadFilter());
        readFilters.add(ReadFilterLibrary.MAPPED);
        readFilters.add(ReadFilterLibrary.PAIRED);
        readFilters.add(ReadFilterLibrary.NONZERO_FRAGMENT_LENGTH_READ_FILTER);
        readFilters.add(ReadFilterLibrary.FIRST_OF_PAIR);
        readFilters.add(ReadFilterLibrary.PROPERLY_PAIRED);
        readFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        readFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        readFilters.add(ReadFilterLibrary.NOT_SUPPLEMENTARY_ALIGNMENT);
        readFilters.add(new MappingQualityReadFilter(0));
        return readFilters;
    }

    @Override
    protected InsertSizeMetricsCollectorArgs makeArg(SAMRecord samRecord, ReferenceSequence refSeq) {
        int insertSize = Math.abs(samRecord.getInferredInsertSize());
        SamPairUtil.PairOrientation orientation = SamPairUtil.getPairOrientation((SAMRecord)samRecord);
        return new InsertSizeMetricsCollectorArgs(insertSize, orientation);
    }

    @Override
    protected PerUnitInsertSizeMetricsCollector makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitInsertSizeMetricsCollector(sample, library, readGroup, this.inputArgs.minimumPct, this.inputArgs.maxMADTolerance, this.inputArgs.histogramWidth);
    }

    public InsertSizeMetricsCollector combine(InsertSizeMetricsCollector target, InsertSizeMetricsCollector source) {
        Utils.nonNull(target);
        Utils.nonNull(source);
        target.combine(source);
        return target;
    }

    @Override
    public PerUnitInsertSizeMetricsCollector combineUnit(PerUnitInsertSizeMetricsCollector collector1, PerUnitInsertSizeMetricsCollector collector2) {
        Utils.nonNull(collector1);
        Utils.nonNull(collector2);
        return collector1.combine(collector2);
    }

    public void finish(MetricsFile<InsertSizeMetrics, Integer> metricsFile, String inputName) {
        Utils.nonNull(metricsFile);
        this.finish();
        this.addAllLevelsToFile(metricsFile);
        if (metricsFile.getNumHistograms() == 0) {
            log.warn("All data categories were discarded because they contained < " + this.inputArgs.minimumPct + " of the total aligned paired data.");
            PerUnitInsertSizeMetricsCollector allReadsCollector = (PerUnitInsertSizeMetricsCollector)this.getAllReadsCollector();
            log.warn("Total mapped pairs in all categories: " + (allReadsCollector == null ? allReadsCollector : Double.valueOf(allReadsCollector.getTotalInserts())));
        } else {
            MetricsUtils.saveMetrics(metricsFile, this.inputArgs.output);
            if (this.inputArgs.producePlot) {
                this.writeHistogramPDF(inputName);
            }
        }
    }

    private void writeHistogramPDF(String inputName) throws RScriptExecutorException {
        String R_SCRIPT = "insertSizeHistogram.R";
        File histFile = new File(this.inputArgs.histogramPlotFile);
        IOUtil.assertFileIsWritable((File)histFile);
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(new Resource("insertSizeHistogram.R", InsertSizeMetricsCollector.class));
        executor.addArgs(this.inputArgs.output, histFile.getAbsolutePath(), inputName);
        if (this.inputArgs.histogramWidth != null) {
            executor.addArgs(String.valueOf(this.inputArgs.histogramWidth));
        }
        executor.exec();
    }
}

