/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

public final class MetricsUtils {
    private MetricsUtils() {
    }

    public static void saveMetrics(MetricsFile<?, ?> metricsFile, String metricsOutputPath) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(BucketUtils.createFile(metricsOutputPath)));){
            metricsFile.write((Writer)out);
        }
        catch (SAMException | IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Could not write metrics to file: " + metricsOutputPath, (Exception)e);
        }
    }
}

