/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.metrics;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.metrics.MetricAccumulationLevel;
import org.broadinstitute.hellbender.metrics.PerUnitMetricCollector;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class MultiLevelReducibleCollector<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNKNOWN = "unknown";
    private List<Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>> outputOrderedDistributors;
    private AllReadsDistributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> allReadsDistributor;
    private static final String ALL_READS_COLLECTOR_KEY = "ALL_READS_COLLECTOR";

    protected abstract ARGTYPE makeArg(SAMRecord var1, ReferenceSequence var2);

    protected abstract UNIT_COLLECTOR makeChildCollector(String var1, String var2, String var3);

    protected UNIT_COLLECTOR makeAllReadCollector() {
        return this.makeChildCollector(null, null, null);
    }

    protected UNIT_COLLECTOR makeSampleCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), null, null);
    }

    protected UNIT_COLLECTOR makeLibraryCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), rg.getLibrary(), null);
    }

    protected UNIT_COLLECTOR makeReadGroupCollector(SAMReadGroupRecord rg) {
        return this.makeChildCollector(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit());
    }

    public void combine(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> source) {
        Utils.nonNull(source);
        if (this.outputOrderedDistributors.size() != source.outputOrderedDistributors.size()) {
            throw new IllegalArgumentException("MultiLevelCollectors must the same size and level structure to be combined");
        }
        for (int i = 0; i < this.outputOrderedDistributors.size(); ++i) {
            this.outputOrderedDistributors.get(i).combine(source.outputOrderedDistributors.get(i), this::combineUnit);
        }
    }

    public abstract UNIT_COLLECTOR combineUnit(UNIT_COLLECTOR var1, UNIT_COLLECTOR var2);

    protected void setup(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords) {
        this.outputOrderedDistributors = new ArrayList<Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>>();
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.ALL_READS)) {
            this.allReadsDistributor = new AllReadsDistributor(this);
            this.allReadsDistributor.initializeFromReadGroups(samRgRecords);
            this.outputOrderedDistributors.add(this.allReadsDistributor);
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.SAMPLE)) {
            SampleDistributor sampleDistributor = new SampleDistributor(this);
            sampleDistributor.initializeFromReadGroups(samRgRecords);
            this.outputOrderedDistributors.add(sampleDistributor);
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.LIBRARY)) {
            LibraryDistributor libraryDistributor = new LibraryDistributor(this);
            libraryDistributor.initializeFromReadGroups(samRgRecords);
            this.outputOrderedDistributors.add(libraryDistributor);
        }
        if (accumulationLevels.contains((Object)MetricAccumulationLevel.READ_GROUP)) {
            ReadGroupDistributor readGroupDistributor = new ReadGroupDistributor(this);
            readGroupDistributor.initializeFromReadGroups(samRgRecords);
            this.outputOrderedDistributors.add(readGroupDistributor);
        }
    }

    public void acceptRecord(SAMRecord record, ReferenceSequence refSeq) {
        ARGTYPE arg = this.makeArg(record, refSeq);
        for (Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> distributor : this.outputOrderedDistributors) {
            distributor.acceptRecord(arg, record.getReadGroup());
        }
    }

    public void finish() {
        for (Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> distributor : this.outputOrderedDistributors) {
            distributor.finish();
        }
    }

    public UNIT_COLLECTOR getAllReadsCollector() {
        return (UNIT_COLLECTOR)(this.allReadsDistributor != null ? (PerUnitMetricCollector)this.allReadsDistributor.collectors.get(ALL_READS_COLLECTOR_KEY) : null);
    }

    public void addAllLevelsToFile(MetricsFile<METRIC_TYPE, HISTOGRAM_KEY> file) {
        for (Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> distributor : this.outputOrderedDistributors) {
            distributor.addToFile(file);
        }
    }

    private class ReadGroupDistributor<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
    extends Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ReadGroupDistributor(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector) {
            super(multiCollector);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getPlatformUnit();
        }

        @Override
        protected UNIT_COLLECTOR makeCollector(SAMReadGroupRecord rg) {
            return this.multiCollector.makeReadGroupCollector(rg);
        }

        @Override
        protected UNIT_COLLECTOR makeUnknownCollector() {
            return this.multiCollector.makeChildCollector(MultiLevelReducibleCollector.UNKNOWN, MultiLevelReducibleCollector.UNKNOWN, MultiLevelReducibleCollector.UNKNOWN);
        }
    }

    private static class LibraryDistributor<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
    extends Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public LibraryDistributor(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector) {
            super(multiCollector);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getLibrary();
        }

        @Override
        protected UNIT_COLLECTOR makeCollector(SAMReadGroupRecord rg) {
            return this.multiCollector.makeLibraryCollector(rg);
        }

        @Override
        protected UNIT_COLLECTOR makeUnknownCollector() {
            return this.multiCollector.makeChildCollector(MultiLevelReducibleCollector.UNKNOWN, MultiLevelReducibleCollector.UNKNOWN, null);
        }
    }

    private static class SampleDistributor<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
    extends Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SampleDistributor(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector) {
            super(multiCollector);
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return rg.getSample();
        }

        @Override
        protected UNIT_COLLECTOR makeCollector(SAMReadGroupRecord rg) {
            return this.multiCollector.makeSampleCollector(rg);
        }

        @Override
        protected UNIT_COLLECTOR makeUnknownCollector() {
            return this.multiCollector.makeChildCollector(MultiLevelReducibleCollector.UNKNOWN, null, null);
        }
    }

    private static class AllReadsDistributor<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
    extends Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public AllReadsDistributor(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector) {
            super(multiCollector);
        }

        @Override
        public void initializeFromReadGroups(List<SAMReadGroupRecord> rgRecs) {
            super.initializeFromReadGroups(new ArrayList<SAMReadGroupRecord>());
            this.collectors.put(MultiLevelReducibleCollector.ALL_READS_COLLECTOR_KEY, this.multiCollector.makeAllReadCollector());
        }

        @Override
        protected String getKey(SAMReadGroupRecord rg) {
            return MultiLevelReducibleCollector.ALL_READS_COLLECTOR_KEY;
        }

        @Override
        protected UNIT_COLLECTOR makeCollector(SAMReadGroupRecord rg) {
            return this.multiCollector.makeAllReadCollector();
        }

        @Override
        protected UNIT_COLLECTOR makeUnknownCollector() {
            throw new UnsupportedOperationException("Should not happen");
        }
    }

    private static abstract class Distributor<METRIC_TYPE extends MetricBase, HISTOGRAM_KEY extends Comparable<HISTOGRAM_KEY>, ARGTYPE, UNIT_COLLECTOR extends PerUnitMetricCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector;
        protected Map<String, UNIT_COLLECTOR> collectors;

        public Distributor(MultiLevelReducibleCollector<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> multiCollector) {
            this.multiCollector = multiCollector;
        }

        public void initializeFromReadGroups(List<SAMReadGroupRecord> rgRecs) {
            this.collectors = new LinkedHashMap<String, UNIT_COLLECTOR>();
            for (SAMReadGroupRecord rg : rgRecs) {
                String key = this.getKey(rg);
                if (this.collectors.containsKey(key)) continue;
                this.collectors.put(key, this.makeCollector(rg));
            }
        }

        protected abstract String getKey(SAMReadGroupRecord var1);

        protected abstract UNIT_COLLECTOR makeCollector(SAMReadGroupRecord var1);

        protected abstract UNIT_COLLECTOR makeUnknownCollector();

        public void acceptRecord(ARGTYPE args, SAMReadGroupRecord rg) {
            PerUnitMetricCollector collector;
            String computedKey;
            String key = MultiLevelReducibleCollector.UNKNOWN;
            if (rg != null && (computedKey = this.getKey(rg)) != null) {
                key = computedKey;
            }
            if ((collector = (PerUnitMetricCollector)this.collectors.get(key)) == null) {
                if (!MultiLevelReducibleCollector.UNKNOWN.equals(key)) {
                    throw new GATKException("Could not find collector for " + key);
                }
                collector = this.makeUnknownCollector();
                this.collectors.put(key, collector);
            }
            collector.acceptRecord(args);
        }

        public void finish() {
            for (PerUnitMetricCollector collector : this.collectors.values()) {
                collector.finish();
            }
        }

        public void combine(Distributor<METRIC_TYPE, HISTOGRAM_KEY, ARGTYPE, UNIT_COLLECTOR> source, BiFunction<UNIT_COLLECTOR, UNIT_COLLECTOR, UNIT_COLLECTOR> reMap) {
            Utils.nonNull(source);
            Utils.nonNull(reMap);
            this.collectors.keySet().forEach(k -> {
                PerUnitMetricCollector cfr_ignored_0 = (PerUnitMetricCollector)this.collectors.merge((String)k, source.collectors.get(k), reMap);
            });
        }

        public void addToFile(MetricsFile<METRIC_TYPE, HISTOGRAM_KEY> file) {
            for (PerUnitMetricCollector collector : this.collectors.values()) {
                collector.addMetricsToFile(file);
            }
        }
    }
}

