/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.metrics;

import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.broadinstitute.hellbender.metrics.InsertSizeMetrics;
import org.broadinstitute.hellbender.metrics.InsertSizeMetricsCollectorArgs;
import org.broadinstitute.hellbender.metrics.PerUnitMetricCollector;
import org.broadinstitute.hellbender.utils.Utils;

public final class PerUnitInsertSizeMetricsCollector
implements PerUnitMetricCollector<InsertSizeMetrics, Integer, InsertSizeMetricsCollectorArgs>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<SamPairUtil.PairOrientation, Histogram<Integer>> histograms = new LinkedHashMap<SamPairUtil.PairOrientation, Histogram<Integer>>();
    private final String sample;
    private final String library;
    private final String readGroup;
    private final double minimumPct;
    private final double deviations;
    private Integer histogramWidth;
    private double totalInserts = 0.0;

    public PerUnitInsertSizeMetricsCollector(String sample, String library, String readGroup, double minimumPct, double deviations, Integer histogramWidth) {
        this.sample = sample;
        this.library = library;
        this.readGroup = readGroup;
        this.minimumPct = minimumPct;
        this.histogramWidth = histogramWidth;
        this.deviations = deviations;
        String prefix = this.createHistogramValuePrefix();
        this.histograms.put(SamPairUtil.PairOrientation.FR, (Histogram<Integer>)new Histogram("insert_size", prefix + "fr_count"));
        this.histograms.put(SamPairUtil.PairOrientation.TANDEM, (Histogram<Integer>)new Histogram("insert_size", prefix + "tandem_count"));
        this.histograms.put(SamPairUtil.PairOrientation.RF, (Histogram<Integer>)new Histogram("insert_size", prefix + "rf_count"));
    }

    @Override
    public void acceptRecord(InsertSizeMetricsCollectorArgs args) {
        this.histograms.get(args.getPairOrientation()).increment((Comparable)Integer.valueOf(args.getInsertSize()));
    }

    @Override
    public void finish() {
    }

    public double getTotalInserts() {
        return this.totalInserts;
    }

    @Override
    public void addMetricsToFile(MetricsFile<InsertSizeMetrics, Integer> file) {
        for (Map.Entry<SamPairUtil.PairOrientation, Histogram<Integer>> entry : this.histograms.entrySet()) {
            this.totalInserts += entry.getValue().getCount();
        }
        for (Map.Entry<SamPairUtil.PairOrientation, Histogram<Integer>> entry : this.histograms.entrySet()) {
            SamPairUtil.PairOrientation pairOrientation = entry.getKey();
            Histogram<Integer> Histogram2 = entry.getValue();
            double total = Histogram2.getCount();
            if (!(total > this.totalInserts * this.minimumPct)) continue;
            InsertSizeMetrics metrics = new InsertSizeMetrics();
            metrics.SAMPLE = this.sample;
            metrics.LIBRARY = this.library;
            metrics.READ_GROUP = this.readGroup;
            metrics.PAIR_ORIENTATION = pairOrientation;
            metrics.READ_PAIRS = (long)total;
            metrics.MAX_INSERT_SIZE = (int)Histogram2.getMax();
            metrics.MIN_INSERT_SIZE = (int)Histogram2.getMin();
            metrics.MEDIAN_INSERT_SIZE = Histogram2.getMedian();
            metrics.MEDIAN_ABSOLUTE_DEVIATION = Histogram2.getMedianAbsoluteDeviation();
            double median = Histogram2.getMedian();
            double covered = 0.0;
            double low = median;
            for (double high = median; low >= Histogram2.getMin() || high <= Histogram2.getMax(); low -= 1.0, high += 1.0) {
                Histogram.Bin highBin;
                Histogram.Bin lowBin = Histogram2.get((Comparable)Integer.valueOf((int)low));
                if (lowBin != null) {
                    covered += lowBin.getValue();
                }
                if (low != high && (highBin = Histogram2.get((Comparable)Integer.valueOf((int)high))) != null) {
                    covered += highBin.getValue();
                }
                double percentCovered = covered / total;
                int distance = (int)(high - low) + 1;
                if (percentCovered >= 0.1 && metrics.WIDTH_OF_10_PERCENT == 0) {
                    metrics.WIDTH_OF_10_PERCENT = distance;
                }
                if (percentCovered >= 0.2 && metrics.WIDTH_OF_20_PERCENT == 0) {
                    metrics.WIDTH_OF_20_PERCENT = distance;
                }
                if (percentCovered >= 0.3 && metrics.WIDTH_OF_30_PERCENT == 0) {
                    metrics.WIDTH_OF_30_PERCENT = distance;
                }
                if (percentCovered >= 0.4 && metrics.WIDTH_OF_40_PERCENT == 0) {
                    metrics.WIDTH_OF_40_PERCENT = distance;
                }
                if (percentCovered >= 0.5 && metrics.WIDTH_OF_50_PERCENT == 0) {
                    metrics.WIDTH_OF_50_PERCENT = distance;
                }
                if (percentCovered >= 0.6 && metrics.WIDTH_OF_60_PERCENT == 0) {
                    metrics.WIDTH_OF_60_PERCENT = distance;
                }
                if (percentCovered >= 0.7 && metrics.WIDTH_OF_70_PERCENT == 0) {
                    metrics.WIDTH_OF_70_PERCENT = distance;
                }
                if (percentCovered >= 0.8 && metrics.WIDTH_OF_80_PERCENT == 0) {
                    metrics.WIDTH_OF_80_PERCENT = distance;
                }
                if (percentCovered >= 0.9 && metrics.WIDTH_OF_90_PERCENT == 0) {
                    metrics.WIDTH_OF_90_PERCENT = distance;
                }
                if (!(percentCovered >= 0.99) || metrics.WIDTH_OF_99_PERCENT != 0) continue;
                metrics.WIDTH_OF_99_PERCENT = distance;
            }
            Histogram<Integer> trimmedHisto = Histogram2;
            if (this.histogramWidth == null) {
                this.histogramWidth = (int)(metrics.MEDIAN_INSERT_SIZE + this.deviations * metrics.MEDIAN_ABSOLUTE_DEVIATION);
            }
            trimmedHisto.trimByWidth(this.histogramWidth.intValue());
            metrics.MEAN_INSERT_SIZE = trimmedHisto.getMean();
            metrics.STANDARD_DEVIATION = trimmedHisto.getStandardDeviation();
            file.addHistogram(trimmedHisto);
            file.addMetric((MetricBase)metrics);
        }
    }

    public PerUnitInsertSizeMetricsCollector combine(PerUnitInsertSizeMetricsCollector sourceCollector) {
        Utils.nonNull(sourceCollector);
        String validationMessage = "Internal error combining collectors";
        PerUnitInsertSizeMetricsCollector.validateEquals(this.sample, sourceCollector.sample, "Internal error combining collectors");
        PerUnitInsertSizeMetricsCollector.validateEquals(this.library, sourceCollector.library, "Internal error combining collectors");
        PerUnitInsertSizeMetricsCollector.validateEquals(this.readGroup, sourceCollector.readGroup, "Internal error combining collectors");
        PerUnitInsertSizeMetricsCollector combinedCollector = new PerUnitInsertSizeMetricsCollector(this.sample, this.library, this.readGroup, this.minimumPct, this.deviations, this.histogramWidth);
        combinedCollector.totalInserts = this.totalInserts + sourceCollector.totalInserts;
        this.histograms.forEach((po, targetHist) -> {
            Histogram<Integer> sourceHist = sourceCollector.histograms.get(po);
            Utils.validate(targetHist.getBinLabel().equals(sourceHist.getBinLabel()) && targetHist.getValueLabel().equals(sourceHist.getValueLabel()), "Internal error combining collectors: attempt to combine mismatched histograms");
            Histogram combinedHist = new Histogram(targetHist.getBinLabel(), targetHist.getValueLabel());
            combinedHist.addHistogram(sourceHist);
            combinedHist.addHistogram(targetHist);
            combinedCollector.histograms.put((SamPairUtil.PairOrientation)po, (Histogram<Integer>)combinedHist);
        });
        return combinedCollector;
    }

    private static void validateEquals(String source, String target, String message) {
        Utils.validate(Objects.equals(source, target), () -> String.format("%s (%s : %s)", message, source == null ? "null" : source, target == null ? "null" : target));
    }

    private String createHistogramValuePrefix() {
        String prefix = this.readGroup != null ? this.readGroup + "." : (this.library != null ? this.library + "." : (this.sample != null ? this.sample + "." : "All_Reads."));
        return prefix;
    }
}

