/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.metrics;

import htsjdk.samtools.metrics.MetricBase;
import java.io.Serializable;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class QualityYieldMetrics
extends MetricBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean useOriginalQualities;
    private boolean finalized;
    public int TOTAL_READS;
    public int PF_READS;
    public int READ_LENGTH;
    public long TOTAL_BASES;
    public long PF_BASES;
    public long Q20_BASES;
    public long PF_Q20_BASES;
    public long Q30_BASES;
    public long PF_Q30_BASES;
    public long Q20_EQUIVALENT_YIELD;
    public long PF_Q20_EQUIVALENT_YIELD;

    public QualityYieldMetrics setUseOriginalQualities(boolean useOriginalQualities) {
        this.useOriginalQualities = useOriginalQualities;
        return this;
    }

    public QualityYieldMetrics addRead(GATKRead read) {
        byte[] quals;
        boolean isPfRead;
        ++this.TOTAL_READS;
        int length = read.getLength();
        boolean bl = isPfRead = !read.failsVendorQualityCheck();
        if (isPfRead) {
            ++this.PF_READS;
            this.PF_BASES += (long)length;
        }
        this.TOTAL_BASES += (long)length;
        if (this.useOriginalQualities) {
            byte[] tmp = ReadUtils.getOriginalBaseQualities(read);
            if (tmp == null) {
                tmp = read.getBaseQualities();
            }
            quals = tmp;
        } else {
            quals = read.getBaseQualities();
        }
        for (byte qual : quals) {
            this.Q20_EQUIVALENT_YIELD += (long)qual;
            if (qual >= 20) {
                ++this.Q20_BASES;
            }
            if (qual >= 30) {
                ++this.Q30_BASES;
            }
            if (!isPfRead) continue;
            this.PF_Q20_EQUIVALENT_YIELD += (long)qual;
            if (qual >= 20) {
                ++this.PF_Q20_BASES;
            }
            if (qual < 30) continue;
            ++this.PF_Q30_BASES;
        }
        return this;
    }

    public QualityYieldMetrics combine(QualityYieldMetrics that) {
        Utils.nonNull(that);
        if (this.useOriginalQualities != that.useOriginalQualities) {
            throw new IllegalArgumentException("must have the same value for useOriginalQualities");
        }
        if (this.finalized || that.finalized) {
            throw new IllegalArgumentException("can;t merge objects when the calculations are finalized");
        }
        this.TOTAL_READS += that.TOTAL_READS;
        this.PF_READS += that.PF_READS;
        this.READ_LENGTH += that.READ_LENGTH;
        this.TOTAL_BASES += that.TOTAL_BASES;
        this.PF_BASES += that.PF_BASES;
        this.Q20_BASES += that.Q20_BASES;
        this.PF_Q20_BASES += that.PF_Q20_BASES;
        this.Q30_BASES += that.Q30_BASES;
        this.PF_Q30_BASES += that.PF_Q30_BASES;
        this.Q20_EQUIVALENT_YIELD += that.Q20_EQUIVALENT_YIELD;
        this.PF_Q20_EQUIVALENT_YIELD += that.PF_Q20_EQUIVALENT_YIELD;
        return this;
    }

    public QualityYieldMetrics finish() {
        this.READ_LENGTH = this.TOTAL_READS == 0 ? 0 : (int)(this.TOTAL_BASES / (long)this.TOTAL_READS);
        this.Q20_EQUIVALENT_YIELD /= 20L;
        this.PF_Q20_EQUIVALENT_YIELD /= 20L;
        this.finalized = true;
        return this;
    }

    public static String getUniqueNameSuffix() {
        return "qualityYieldMetrics";
    }
}

