/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.testutils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.MultiDeBruijnVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingGraph;
import org.broadinstitute.hellbender.utils.Utils;

public final class TestingReadThreadingGraph
extends ReadThreadingGraph {
    private static final Pattern PROPERTIES_PATTERN = Pattern.compile("^\\s*\\[[^\\]]*\\]");
    private static final Pattern PATH_PATTERN = Pattern.compile("\\{((\\S+):)?([^\\}]*)\\}");
    private static final Pattern KMERSIZE_EXTRACTOR_PATTERN = Pattern.compile("^\\s*\\[[^\\]]*(ks|kmerSize)\\s*=\\s*(\\d+)\\s*[,\\]]");
    private static final long serialVersionUID = 1L;

    public TestingReadThreadingGraph(String s) {
        super(TestingReadThreadingGraph.kmerSizeFromString(s));
        this.applyString(s);
        this.setAlreadyBuilt();
    }

    private static int kmerSizeFromString(String str) {
        Matcher matcher = KMERSIZE_EXTRACTOR_PATTERN.matcher(str);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        throw new IllegalArgumentException("the input graph spec does not indicate the kmerSize");
    }

    private void applyString(String str) {
        Matcher propertiesSectionMatcher = PROPERTIES_PATTERN.matcher(str);
        int pathStart = propertiesSectionMatcher.find() ? propertiesSectionMatcher.end() : 0;
        String pathString = str.substring(pathStart);
        Matcher pathMatcher = PATH_PATTERN.matcher(pathString);
        boolean referenceFound = false;
        HashMap<String, MultiDeBruijnVertex> vertexById = new HashMap<String, MultiDeBruijnVertex>();
        while (pathMatcher.find()) {
            MultiDeBruijnVertex firstVertex;
            boolean isSource;
            String label = pathMatcher.group(2);
            boolean isReference = "REF".equals(label);
            if (referenceFound) {
                Utils.validateArg(!isReference, "there are two reference paths");
            } else if (isReference) {
                referenceFound = true;
            }
            String elementsString = pathMatcher.group(3);
            String[] elements = elementsString.split("\\s*->\\s*");
            Utils.validateArg(elements.length > 0, "empty path not allowed");
            String[] seqs = new String[elements.length];
            String[] ids = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                ids[i] = TestingReadThreadingGraph.pathElementId(elements[i]);
                seqs[i] = TestingReadThreadingGraph.pathElementSeq(elements[i]);
                Utils.validateArg(!seqs[i].isEmpty() || ids[i] != null, "path with empty element without an id");
            }
            boolean bl = isSource = ids[0] == null || !vertexById.containsKey(ids[0]);
            if (isSource && seqs[0].length() != this.kmerSize) {
                throw new IllegalArgumentException("source sequence length must be the same as the kmerSize " + ids[0] + ' ' + seqs[0] + ' ' + pathMatcher.group());
            }
            if (ids[0] != null && vertexById.containsKey(ids[0])) {
                firstVertex = (MultiDeBruijnVertex)vertexById.get(ids[0]);
            } else {
                firstVertex = new MultiDeBruijnVertex(seqs[0].getBytes());
                this.addVertex(firstVertex);
                if (ids[0] != null) {
                    vertexById.put(ids[0], firstVertex);
                }
            }
            if (!seqs[0].isEmpty() && (isSource && !firstVertex.getSequenceString().equals(seqs[0]) || !isSource && firstVertex.getSuffix() != seqs[0].getBytes()[0])) {
                throw new IllegalArgumentException("mismatched first element sequence");
            }
            MultiDeBruijnVertex lastVertex = firstVertex;
            for (int i = 1; i < elements.length; ++i) {
                MultiDeBruijnVertex nextVertex;
                Utils.validateArg(seqs[i].length() <= 1, "non-source vertex sequence must have length 1");
                if (ids[i] == null || !vertexById.containsKey(ids[i])) {
                    Set<MultiDeBruijnVertex> nextVertices = this.getNextVertices(lastVertex, seqs[i].getBytes()[0]);
                    if (nextVertices.isEmpty()) {
                        nextVertex = new MultiDeBruijnVertex(TestingReadThreadingGraph.extendSequence(lastVertex.getSequence(), seqs[i].getBytes()[0]));
                        this.addVertex(nextVertex);
                    } else {
                        nextVertex = nextVertices.iterator().next();
                    }
                    if (ids[i] != null) {
                        vertexById.put(ids[i], nextVertex);
                    }
                } else {
                    nextVertex = (MultiDeBruijnVertex)vertexById.get(ids[i]);
                }
                MultiSampleEdge edge = (MultiSampleEdge)this.addEdge(lastVertex, nextVertex);
                if (isReference) {
                    edge.setIsRef(true);
                }
                lastVertex = nextVertex;
            }
        }
    }

    @VisibleForTesting
    Set<MultiDeBruijnVertex> getNextVertices(MultiDeBruijnVertex v, byte b) {
        Utils.nonNull(v, "the input vertex cannot be null");
        Utils.validateArg(this.vertexSet().contains(v), "the vertex must be present in the graph");
        LinkedList<MultiDeBruijnVertex> result = new LinkedList<MultiDeBruijnVertex>();
        for (MultiDeBruijnVertex w : this.outgoingVerticesOf(v)) {
            if (w.getSuffix() != b) continue;
            result.add(w);
        }
        switch (result.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(result.get(0));
            }
        }
        return new HashSet<MultiDeBruijnVertex>(result);
    }

    private static String pathElementId(String element) {
        int openBracketPosition = element.indexOf(40);
        if (openBracketPosition == -1) {
            return null;
        }
        int closeBracketPosition = element.lastIndexOf(41);
        Utils.validateArg(closeBracketPosition != -1, () -> "non-closed id parantesys found in element: " + element);
        String result = element.substring(openBracketPosition + 1, closeBracketPosition).trim();
        Utils.validateArg(!result.isEmpty(), () -> "empty id found in element: " + element);
        return result;
    }

    private static String pathElementSeq(String element) {
        int parentesysPos = element.indexOf(40);
        if (parentesysPos == -1) {
            return element.trim();
        }
        return element.substring(0, parentesysPos).trim();
    }

    private static byte[] extendSequence(byte[] sequence, byte b) {
        byte[] result = new byte[sequence.length];
        System.arraycopy(sequence, 1, result, 0, sequence.length - 1);
        result[result.length - 1] = b;
        return result;
    }

    @Override
    public TestingReadThreadingGraph clone() {
        return (TestingReadThreadingGraph)super.clone();
    }
}

