/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.SAMTag;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Adds Original Alignment tag and original mate contig tag", oneLineSummary="Adds Original Alignment tag and original mate contig tag", programGroup=ReadDataManipulationProgramGroup.class)
@ExperimentalFeature
@WorkflowProperties
public class AddOriginalAlignmentTags
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath output;
    private SAMFileGATKReadWriter outputWriter;
    public static final String MATE_CONTIG_TAG_NAME = "XM";
    public static final String OA_TAG_NAME = "OA";
    public static final String OA_SEPARATOR = ",";

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.output, true);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        AddOriginalAlignmentTags.addOATag(read);
        AddOriginalAlignmentTags.addMateContigTag(read);
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }

    private static void addMateContigTag(GATKRead read) {
        read.setAttribute(MATE_CONTIG_TAG_NAME, !read.mateIsUnmapped() ? read.getMateContig() : "*");
    }

    private static void addOATag(GATKRead read) {
        String OAValue = !read.isUnmapped() ? String.format("%s,%s,%s,%s,%s,%s;", read.getContig().replace(OA_SEPARATOR, "_"), read.getStart(), read.isReverseStrand() ? "-" : "+", read.getCigar().toString(), read.getMappingQuality(), read.getAttributeAsString(SAMTag.NM.name())) : "*,0,*,*,0,0;";
        read.setAttribute(OA_TAG_NAME, OAValue);
    }

    public static String getOAContig(GATKRead read) {
        return read.getAttributeAsString(OA_TAG_NAME).split(OA_SEPARATOR)[0];
    }
}

