/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.tools.ApplyBQSRArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;

public class ApplyBQSRUniqueArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="quantize-quals", doc="Quantize quality scores to a given number of levels", optional=true)
    public int quantizationLevels = 0;
    @Advanced
    @Argument(fullName="static-quantized-quals", doc="Use static quantized quality scores to a given number of levels (with -bqsr)", optional=true, mutex={"quantize-quals"})
    public List<Integer> staticQuantizationQuals = new ArrayList<Integer>();
    @Advanced
    @Argument(fullName="round-down-quantized", doc="Round quals down to nearest quantized qual", optional=true, mutex={"quantize-quals"})
    public boolean roundDown = false;
    @Argument(fullName="emit-original-quals", doc="Emit original base qualities under the OQ tag", optional=true)
    public boolean emitOriginalQuals = false;
    @Argument(fullName="global-qscore-prior", doc="Global Qscore Bayesian prior to use for BQSR", optional=true)
    public double globalQScorePrior = -1.0;

    public ApplyBQSRArgumentCollection toApplyBQSRArgumentCollection(RecalibrationArgumentCollection bqsrArgs) {
        ApplyBQSRArgumentCollection ret = new ApplyBQSRArgumentCollection();
        ret.quantizationLevels = this.quantizationLevels;
        ret.staticQuantizationQuals = this.staticQuantizationQuals;
        ret.roundDown = this.roundDown;
        ret.emitOriginalQuals = this.emitOriginalQuals;
        ret.globalQScorePrior = this.globalQScorePrior;
        ret.PRESERVE_QSCORES_LESS_THAN = bqsrArgs.PRESERVE_QSCORES_LESS_THAN;
        ret.useOriginalBaseQualities = bqsrArgs.useOriginalBaseQualities;
        return ret;
    }
}

