/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Create a BWA-MEM index image file for use with GATK BWA tools", oneLineSummary="Create a BWA-MEM index image file for use with GATK BWA tools", programGroup=ReferenceProgramGroup.class)
public final class BwaMemIndexImageCreator
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="Input reference FASTA file location.")
    private String referenceFastaLoc = null;
    @Argument(fullName="output", shortName="O", doc="Output reference index image file (ending in \".img\").", optional=true)
    private String referenceIndexImageOutputLoc = null;

    @Override
    protected final Object doWork() {
        if (this.referenceIndexImageOutputLoc == null) {
            this.referenceIndexImageOutputLoc = this.referenceFastaLoc + ".img";
        }
        BwaMemIndex.createIndexImageFromFastaFile((String)this.referenceFastaLoc, (String)this.referenceIndexImageOutputLoc);
        return null;
    }
}

