/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.StringUtil;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.clipping.ClippingOp;
import org.broadinstitute.hellbender.utils.clipping.ClippingRepresentation;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Read clipping based on quality, position or sequence matching. This tool provides simple, powerful read clipping capabilities that allow you to remove low quality strings of bases, sections of reads, and reads containing user-provided sequences.", oneLineSummary="Clip reads in a SAM/BAM/CRAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class ClipReads
extends ReadWalker {
    private final Logger logger = LogManager.getLogger(ClipReads.class);
    public static final String OUTPUT_STATISTICS_LONG_NAME = "output-statistics";
    public static final String OUTPUT_STATISTICS_SHORT_NAME = "os";
    public static final String Q_TRIMMING_THRESHOLD_LONG_NAME = "q-trimming-threshold";
    public static final String Q_TRIMMING_THRESHOLD_SHORT_NAME = "QT";
    public static final String CYCLES_TO_TRIM_LONG_NAME = "cycles-to-trim";
    public static final String CYCLES_TO_TRIM_SHORT_NAME = "CT";
    public static final String CLIP_SEQUENCES_FILE_LONG_NAME = "clip-sequences-file";
    public static final String CLIP_SEQUENCES_FILE_SHORT_NAME = "XF";
    public static final String CLIP_SEQUENCE_LONG_NAME = "clip-sequence";
    public static final String CLIP_SEQUENCE_SHORT_NAME = "X";
    public static final String CLIP_REPRESENTATION_LONG_NAME = "clip-representation";
    public static final String CLIP_REPRESENTATION_SHORT_NAME = "CR";
    public static final String READ_LONG_NAME = "read";
    public static final String READ_SHORT_NAME = "read";
    @Argument(doc="BAM output file", shortName="O", fullName="output")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    GATKPath OUTPUT;
    @Argument(fullName="output-statistics", shortName="os", doc="File to output statistics", optional=true)
    @WorkflowOutput
    GATKPath STATSOUTPUT = null;
    @Argument(fullName="q-trimming-threshold", shortName="QT", doc="If provided, the Q-score clipper will be applied", optional=true)
    int qTrimmingThreshold = -1;
    @Argument(fullName="cycles-to-trim", shortName="CT", doc="String indicating machine cycles to clip from the reads", optional=true)
    String cyclesToClipArg = null;
    @Argument(fullName="clip-sequences-file", shortName="XF", doc="Remove sequences within reads matching the sequences in this FASTA file", optional=true)
    GATKPath clipSequenceFile = null;
    @Argument(fullName="clip-sequence", shortName="X", doc="Remove sequences within reads matching this sequence", optional=true)
    List<String> clipSequencesArgs = null;
    @Argument(fullName="clip-representation", shortName="CR", doc="How should we actually clip the bases?", optional=true)
    ClippingRepresentation clippingRepresentation = ClippingRepresentation.WRITE_NS;
    @Argument(fullName="read", shortName="read", doc="", optional=true)
    String onlyDoRead = null;
    private final List<SeqToClip> sequencesToClip = new ArrayList<SeqToClip>();
    private List<Pair<Integer, Integer>> cyclesToClip = null;
    private SAMFileGATKReadWriter outputBam;
    private ClippingData accumulator;
    private PrintStream outputStats;

    @Override
    public void onTraversalStart() {
        if (this.qTrimmingThreshold >= 0) {
            this.logger.info(String.format("Creating Q-score clipper with threshold %d", this.qTrimmingThreshold));
        }
        if (this.clipSequencesArgs != null) {
            int i = 0;
            for (String toClip : this.clipSequencesArgs) {
                ReferenceSequence rs = new ReferenceSequence("CMDLINE-" + ++i, -1, StringUtil.stringToBytes((String)toClip));
                this.addSeqToClip(rs.getName(), rs.getBases());
            }
        }
        if (this.clipSequenceFile != null) {
            ReferenceSequence rs;
            ReferenceSequenceFile rsf = ReferenceSequenceFileFactory.getReferenceSequenceFile((Path)this.clipSequenceFile.toPath());
            while ((rs = rsf.nextSequence()) != null) {
                this.addSeqToClip(rs.getName(), rs.getBases());
            }
        }
        if (this.cyclesToClipArg != null) {
            this.cyclesToClip = new ArrayList<Pair<Integer, Integer>>();
            for (String range : this.cyclesToClipArg.split(",")) {
                try {
                    String[] elts = range.split("-");
                    int start = Integer.parseInt(elts[0]) - 1;
                    int stop = Integer.parseInt(elts[1]) - 1;
                    if (start < 0) {
                        throw new Exception();
                    }
                    if (stop < start) {
                        throw new Exception();
                    }
                    this.logger.info(String.format("Creating cycle clipper %d-%d", start, stop));
                    this.cyclesToClip.add((Pair<Integer, Integer>)new MutablePair((Object)start, (Object)stop));
                }
                catch (Exception e) {
                    throw new RuntimeException("Badly formatted cyclesToClip argument: " + this.cyclesToClipArg);
                }
            }
        }
        boolean presorted = EnumSet.of(ClippingRepresentation.WRITE_NS, ClippingRepresentation.WRITE_NS_Q0S, ClippingRepresentation.WRITE_Q0S).contains((Object)this.clippingRepresentation);
        this.outputBam = this.createSAMWriter(this.OUTPUT, presorted);
        this.accumulator = new ClippingData(this.sequencesToClip);
        this.outputStats = this.STATSOUTPUT == null ? null : new PrintStream(this.STATSOUTPUT.getOutputStream());
    }

    @Override
    public void apply(GATKRead read, ReferenceContext ref, FeatureContext featureContext) {
        if (this.onlyDoRead == null || read.getName().equals(this.onlyDoRead)) {
            if (this.clippingRepresentation == ClippingRepresentation.HARDCLIP_BASES || this.clippingRepresentation == ClippingRepresentation.REVERT_SOFTCLIPPED_BASES) {
                read = ReadClipper.revertSoftClippedBases(read);
            }
            ReadClipperWithData clipper = new ReadClipperWithData(read, this.sequencesToClip);
            this.clipBadQualityScores(clipper);
            this.clipCycles(clipper);
            this.clipSequences(clipper);
            this.accumulate(clipper);
        }
    }

    @Override
    public ClippingData onTraversalSuccess() {
        if (this.outputStats != null) {
            this.outputStats.printf(this.accumulator.toString(), new Object[0]);
        }
        return this.accumulator;
    }

    @Override
    public void closeTool() {
        if (this.outputStats != null) {
            this.outputStats.close();
        }
        if (this.outputBam != null) {
            this.outputBam.close();
        }
    }

    private void addSeqToClip(String name, byte[] bases) {
        SeqToClip clip = new SeqToClip(name, bases);
        this.sequencesToClip.add(clip);
        this.logger.info(String.format("Creating sequence clipper %s: %s/%s", clip.name, clip.seq, clip.revSeq));
    }

    private void clipSequences(ReadClipperWithData clipper) {
        if (this.sequencesToClip != null) {
            GATKRead read = clipper.getRead();
            ClippingData data = clipper.getData();
            for (SeqToClip stc : this.sequencesToClip) {
                Pattern pattern = read.isReverseStrand() ? stc.revPat : stc.fwdPat;
                String bases = read.getBasesString();
                Matcher match = pattern.matcher(bases);
                boolean found = true;
                while (found) {
                    found = match.find();
                    if (!found) continue;
                    int start = match.start();
                    int stop = match.end() - 1;
                    ClippingOp op = new ClippingOp(start, stop);
                    clipper.addOp(op);
                    data.incSeqClippedBases(stc.seq, op.getLength());
                }
            }
            clipper.setData(data);
        }
    }

    private Pair<Integer, Integer> strandAwarePositions(GATKRead read, int start, int stop) {
        if (read.isReverseStrand()) {
            return new MutablePair((Object)(read.getLength() - stop - 1), (Object)(read.getLength() - start - 1));
        }
        return new MutablePair((Object)start, (Object)stop);
    }

    private void clipCycles(ReadClipperWithData clipper) {
        if (this.cyclesToClip != null) {
            GATKRead read = clipper.getRead();
            ClippingData data = clipper.getData();
            for (Pair<Integer, Integer> p : this.cyclesToClip) {
                int cycleStart = (Integer)p.getLeft();
                int cycleStop = (Integer)p.getRight();
                if (cycleStart >= read.getLength()) continue;
                if (cycleStop >= read.getLength()) {
                    cycleStop = read.getLength() - 1;
                }
                Pair<Integer, Integer> startStop = this.strandAwarePositions(read, cycleStart, cycleStop);
                int start = (Integer)startStop.getLeft();
                int stop = (Integer)startStop.getRight();
                ClippingOp op = new ClippingOp(start, stop);
                clipper.addOp(op);
                data.incNRangeClippedBases(op.getLength());
            }
            clipper.setData(data);
        }
    }

    private void clipBadQualityScores(ReadClipperWithData clipper) {
        GATKRead read = clipper.getRead();
        ClippingData data = clipper.getData();
        int readLen = read.getLength();
        byte[] quals = read.getBaseQualities();
        int clipSum = 0;
        int lastMax = -1;
        int clipPoint = -1;
        for (int i = readLen - 1; i >= 0; --i) {
            int baseIndex = read.isReverseStrand() ? readLen - i - 1 : i;
            byte qual = quals[baseIndex];
            if ((clipSum += this.qTrimmingThreshold - qual) < 0 || clipSum < lastMax) continue;
            lastMax = clipSum;
            clipPoint = baseIndex;
        }
        if (clipPoint != -1) {
            int start = read.isReverseStrand() ? 0 : clipPoint;
            int stop = read.isReverseStrand() ? clipPoint : readLen - 1;
            ClippingOp op = new ClippingOp(start, stop);
            clipper.addOp(op);
            data.incNQClippedBases(op.getLength());
        }
        clipper.setData(data);
    }

    private void accumulate(ReadClipperWithData clipper) {
        if (clipper == null) {
            return;
        }
        GATKRead clippedRead = clipper.clipRead(this.clippingRepresentation);
        this.outputBam.addRead(clippedRead);
        ++this.accumulator.nTotalReads;
        this.accumulator.nTotalBases += (long)clipper.getRead().getLength();
        if (clipper.wasClipped()) {
            ++this.accumulator.nClippedReads;
            this.accumulator.addData(clipper.getData());
        }
    }

    public static final class ReadClipperWithData
    extends ReadClipper {
        private ClippingData data;

        public ReadClipperWithData(GATKRead read, List<SeqToClip> clipSeqs) {
            super(read);
            this.data = new ClippingData(clipSeqs);
        }

        public ClippingData getData() {
            return this.data;
        }

        public void setData(ClippingData data) {
            this.data = data;
        }

        public void addData(ClippingData data) {
            this.data.addData(data);
        }
    }

    public static final class ClippingData {
        public long nTotalReads = 0L;
        public long nTotalBases = 0L;
        public long nClippedReads = 0L;
        public long nClippedBases = 0L;
        public long nQClippedBases = 0L;
        public long nRangeClippedBases = 0L;
        public long nSeqClippedBases = 0L;
        SortedMap<String, Long> seqClipCounts = new TreeMap<String, Long>();

        public ClippingData(List<SeqToClip> clipSeqs) {
            for (SeqToClip clipSeq : clipSeqs) {
                this.seqClipCounts.put(clipSeq.seq, 0L);
            }
        }

        public void incNQClippedBases(int n) {
            this.nQClippedBases += (long)n;
            this.nClippedBases += (long)n;
        }

        public void incNRangeClippedBases(int n) {
            this.nRangeClippedBases += (long)n;
            this.nClippedBases += (long)n;
        }

        public void incSeqClippedBases(String seq, int n) {
            this.nSeqClippedBases += (long)n;
            this.nClippedBases += (long)n;
            this.seqClipCounts.put(seq, (Long)this.seqClipCounts.get(seq) + (long)n);
        }

        public void addData(ClippingData data) {
            this.nTotalReads += data.nTotalReads;
            this.nTotalBases += data.nTotalBases;
            this.nClippedReads += data.nClippedReads;
            this.nClippedBases += data.nClippedBases;
            this.nQClippedBases += data.nQClippedBases;
            this.nRangeClippedBases += data.nRangeClippedBases;
            this.nSeqClippedBases += data.nSeqClippedBases;
            for (String seqClip : data.seqClipCounts.keySet()) {
                Long count = (Long)data.seqClipCounts.get(seqClip);
                if (this.seqClipCounts.containsKey(seqClip)) {
                    count = count + (Long)this.seqClipCounts.get(seqClip);
                }
                this.seqClipCounts.put(seqClip, count);
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(StringUtils.repeat((char)'-', (int)80) + "\n").append(String.format("Number of examined reads              %d%n", this.nTotalReads)).append(String.format("Number of clipped reads               %d%n", this.nClippedReads)).append(String.format("Percent of clipped reads              %.2f%n", 100.0 * (double)this.nClippedReads / (double)this.nTotalReads)).append(String.format("Number of examined bases              %d%n", this.nTotalBases)).append(String.format("Number of clipped bases               %d%n", this.nClippedBases)).append(String.format("Percent of clipped bases              %.2f%n", 100.0 * (double)this.nClippedBases / (double)this.nTotalBases)).append(String.format("Number of quality-score clipped bases %d%n", this.nQClippedBases)).append(String.format("Number of range clipped bases         %d%n", this.nRangeClippedBases)).append(String.format("Number of sequence clipped bases      %d%n", this.nSeqClippedBases));
            for (Map.Entry<String, Long> elt : this.seqClipCounts.entrySet()) {
                s.append(String.format("  %8d clip sites matching %s%n", elt.getValue(), elt.getKey()));
            }
            s.append(StringUtils.repeat((char)'-', (int)80) + "\n");
            return s.toString();
        }
    }

    private static final class SeqToClip {
        String name;
        String seq;
        String revSeq;
        Pattern fwdPat;
        Pattern revPat;

        public SeqToClip(String name, byte[] bytez) {
            this.name = name;
            this.seq = new String(bytez);
            this.fwdPat = Pattern.compile(this.seq, 2);
            this.revSeq = new String(BaseUtils.simpleReverseComplement(bytez));
            this.revPat = Pattern.compile(this.revSeq, 2);
        }
    }
}

