/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.SAMSequenceDictionary;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.RequiredReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.GenomeLocSortedSet;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;

@CommandLineProgramProperties(summary="Compare two interval lists to see if they are equal", oneLineSummary="Compare two interval lists for equality", programGroup=IntervalsManipulationProgramGroup.class)
public class CompareIntervalLists
extends CommandLineProgram {
    @Argument(fullName="L")
    public String firstIntervalFile;
    @Argument(fullName="L2")
    public String secondIntervalFile;
    @ArgumentCollection
    final ReferenceInputArgumentCollection reference = new RequiredReferenceInputArgumentCollection();

    @Override
    public Object doWork() {
        SAMSequenceDictionary samSequenceDictionary;
        try (ReferenceDataSource ref = ReferenceDataSource.of(this.reference.getReferencePath());){
            samSequenceDictionary = ref.getSequenceDictionary();
        }
        GenomeLocParser genomeLocParser = new GenomeLocParser(samSequenceDictionary);
        GenomeLocSortedSet firstIntervals = CompareIntervalLists.getGenomeLocs(genomeLocParser, this.firstIntervalFile);
        GenomeLocSortedSet secondIntervals = CompareIntervalLists.getGenomeLocs(genomeLocParser, this.secondIntervalFile);
        String result = IntervalUtils.equateIntervals(firstIntervals.toList(), secondIntervals.toList());
        if (result == null) {
            System.out.println("Intervals are equal");
            return 0;
        }
        throw new UserException("Intervals are not equal: \n" + result);
    }

    private static GenomeLocSortedSet getGenomeLocs(GenomeLocParser genomeLocParser, String intervalFile) {
        List<GenomeLoc> genomeLocs = IntervalUtils.parseIntervalArguments(genomeLocParser, intervalFile);
        return IntervalUtils.sortAndMergeIntervals(genomeLocParser, genomeLocs, IntervalMergingRule.ALL);
    }
}

