/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalTextOutputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature
@CommandLineProgramProperties(summary="Count and print to standard output (and optionally to a file) the total number of bases in a SAM/BAM/CRAM file", oneLineSummary="Count bases in a SAM/BAM/CRAM file", programGroup=CoverageAnalysisProgramGroup.class)
@WorkflowProperties
public final class CountBases
extends ReadWalker {
    private long count = 0L;
    @ArgumentCollection
    public final OptionalTextOutputArgumentCollection out = new OptionalTextOutputArgumentCollection();

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.count += (long)read.getLength();
    }

    @Override
    public Object onTraversalSuccess() {
        this.out.print(this.count);
        return this.count;
    }
}

