/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalTextOutputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Count and print to standard output (and optionally to a file) the total number of reads in a SAM/BAM/CRAM file", oneLineSummary="Count reads in a SAM/BAM/CRAM file", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class CountReads
extends ReadWalker {
    private long count = 0L;
    @ArgumentCollection
    public final OptionalTextOutputArgumentCollection out = new OptionalTextOutputArgumentCollection();

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        ++this.count;
    }

    @Override
    public Object onTraversalSuccess() {
        this.logger.info("CountReads counted " + this.count + " total reads");
        this.out.print(this.count);
        return this.count;
    }
}

