/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import java.io.Serializable;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsamplingIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class DownsampleableSparkReadShard
implements Shard<GATKRead>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ShardBoundary boundaries;
    private final Iterable<GATKRead> reads;
    private final ReadsDownsampler downsampler;

    public DownsampleableSparkReadShard(ShardBoundary boundaries, Iterable<GATKRead> reads, ReadsDownsampler downsampler) {
        this.boundaries = Utils.nonNull(boundaries);
        this.reads = Utils.nonNull(reads);
        this.downsampler = downsampler;
    }

    @Override
    public SimpleInterval getInterval() {
        return this.boundaries.getInterval();
    }

    @Override
    public SimpleInterval getPaddedInterval() {
        return this.boundaries.getPaddedSpan();
    }

    @Override
    public Iterator<GATKRead> iterator() {
        ReadsDownsamplingIterator readsIterator = this.reads.iterator();
        if (this.downsampler != null) {
            readsIterator = new ReadsDownsamplingIterator(readsIterator, this.downsampler);
        }
        return readsIterator;
    }
}

