/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.transformers.MisencodedBaseQualityReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Fixes Illumina base quality scores in a SAM/BAM/CRAM file", oneLineSummary="Fix Illumina base quality scores in a SAM/BAM/CRAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class FixMisencodedBaseQualityReads
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath OUTPUT;
    private SAMFileGATKReadWriter outputWriter;
    private ReadTransformer transform;

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.OUTPUT, true);
        this.transform = new MisencodedBaseQualityReadTransformer();
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputWriter.addRead((GATKRead)this.transform.apply(read));
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

