/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalTextOutputArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Accumulate flag statistics given a BAM file, e.g. total number of reads with QC failure flag set, number of\nduplicates, percentage mapped etc. and output summary to standard output (and optionally to a file).", oneLineSummary="Accumulate flag statistics given a BAM file", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class FlagStat
extends ReadWalker {
    private final FlagStatus sum = new FlagStatus();
    @ArgumentCollection
    public final OptionalTextOutputArgumentCollection out = new OptionalTextOutputArgumentCollection();

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.sum.add(read);
    }

    @Override
    public Object onTraversalSuccess() {
        this.out.print(this.sum);
        return this.sum;
    }

    public static final class FlagStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long readCount = 0L;
        long QC_failure = 0L;
        long duplicates = 0L;
        long mapped = 0L;
        long paired_in_sequencing = 0L;
        long read1 = 0L;
        long read2 = 0L;
        long properly_paired = 0L;
        long with_itself_and_mate_mapped = 0L;
        long singletons = 0L;
        long with_mate_mapped_to_a_different_chr = 0L;
        long with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 = 0L;

        public String toString() {
            String ret = "";
            DecimalFormat percentFormatter = new DecimalFormat("#0.00");
            return ret + this.readCount + " in total\n" + this.QC_failure + " QC failure\n" + this.duplicates + " duplicates\n" + this.mapped + " mapped (" + percentFormatter.format((double)((float)this.mapped / (float)this.readCount) * 100.0) + "%)\n" + this.paired_in_sequencing + " paired in sequencing\n" + this.read1 + " read1\n" + this.read2 + " read2\n" + this.properly_paired + " properly paired (" + percentFormatter.format((double)((float)this.properly_paired / (float)this.readCount) * 100.0) + "%)\n" + this.with_itself_and_mate_mapped + " with itself and mate mapped\n" + this.singletons + " singletons (" + percentFormatter.format((double)((float)this.singletons / (float)this.readCount) * 100.0) + "%)\n" + this.with_mate_mapped_to_a_different_chr + " with mate mapped to a different chr\n" + this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 + " with mate mapped to a different chr (mapQ>=5)";
        }

        public FlagStatus merge(FlagStatus that) {
            this.readCount += that.readCount;
            this.QC_failure += that.QC_failure;
            this.duplicates += that.duplicates;
            this.mapped += that.mapped;
            this.paired_in_sequencing += that.paired_in_sequencing;
            this.read1 += that.read1;
            this.read2 += that.read2;
            this.properly_paired += that.properly_paired;
            this.with_itself_and_mate_mapped += that.with_itself_and_mate_mapped;
            this.singletons += that.singletons;
            this.with_mate_mapped_to_a_different_chr += that.with_mate_mapped_to_a_different_chr;
            this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 += that.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
            return this;
        }

        public FlagStatus add(GATKRead read) {
            ++this.readCount;
            if (read.failsVendorQualityCheck()) {
                ++this.QC_failure;
            }
            if (read.isDuplicate()) {
                ++this.duplicates;
            }
            if (!read.isUnmapped()) {
                ++this.mapped;
            }
            if (read.isPaired()) {
                ++this.paired_in_sequencing;
                if (read.isSecondOfPair()) {
                    ++this.read2;
                } else if (read.isFirstOfPair()) {
                    ++this.read1;
                }
                if (read.isProperlyPaired()) {
                    ++this.properly_paired;
                }
                if (!read.isUnmapped() && !read.mateIsUnmapped()) {
                    ++this.with_itself_and_mate_mapped;
                    if (!read.getContig().equals(read.getMateContig())) {
                        ++this.with_mate_mapped_to_a_different_chr;
                        if (read.getMappingQuality() >= 5) {
                            ++this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
                        }
                    }
                }
                if (!read.isUnmapped() && read.mateIsUnmapped()) {
                    ++this.singletons;
                }
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlagStatus that = (FlagStatus)o;
            if (this.QC_failure != that.QC_failure) {
                return false;
            }
            if (this.duplicates != that.duplicates) {
                return false;
            }
            if (this.mapped != that.mapped) {
                return false;
            }
            if (this.paired_in_sequencing != that.paired_in_sequencing) {
                return false;
            }
            if (this.properly_paired != that.properly_paired) {
                return false;
            }
            if (this.read1 != that.read1) {
                return false;
            }
            if (this.read2 != that.read2) {
                return false;
            }
            if (this.readCount != that.readCount) {
                return false;
            }
            if (this.singletons != that.singletons) {
                return false;
            }
            if (this.with_itself_and_mate_mapped != that.with_itself_and_mate_mapped) {
                return false;
            }
            if (this.with_mate_mapped_to_a_different_chr != that.with_mate_mapped_to_a_different_chr) {
                return false;
            }
            return this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 == that.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
        }

        public int hashCode() {
            int result = (int)(this.readCount ^ this.readCount >>> 32);
            result = 31 * result + (int)(this.QC_failure ^ this.QC_failure >>> 32);
            result = 31 * result + (int)(this.duplicates ^ this.duplicates >>> 32);
            result = 31 * result + (int)(this.mapped ^ this.mapped >>> 32);
            result = 31 * result + (int)(this.paired_in_sequencing ^ this.paired_in_sequencing >>> 32);
            result = 31 * result + (int)(this.read1 ^ this.read1 >>> 32);
            result = 31 * result + (int)(this.read2 ^ this.read2 >>> 32);
            result = 31 * result + (int)(this.properly_paired ^ this.properly_paired >>> 32);
            result = 31 * result + (int)(this.with_itself_and_mate_mapped ^ this.with_itself_and_mate_mapped >>> 32);
            result = 31 * result + (int)(this.singletons ^ this.singletons >>> 32);
            result = 31 * result + (int)(this.with_mate_mapped_to_a_different_chr ^ this.with_mate_mapped_to_a_different_chr >>> 32);
            result = 31 * result + (int)(this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 ^ this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 >>> 32);
            return result;
        }
    }
}

