/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Emit a single sample name from the bam header into an output file. The sample name is that in the read group (RG) sample (SM) field", oneLineSummary="Emit a single sample name", programGroup=DiagnosticsAndQCProgramGroup.class)
public final class GetSampleName
extends GATKTool {
    public static final String STANDARD_ENCODING = "UTF-8";
    @Argument(doc="Output file with only the sample name in it.", fullName="output", shortName="O")
    protected GATKPath outputSampleNameFile;
    public static final String URL_ENCODING_LONG_NAME = "use-url-encoding";
    public static final String URL_ENCODING_SHORT_NAME = "encode";
    @Argument(doc="Apply URL encoding to convert spaces and other special characters in sample name.", fullName="use-url-encoding", shortName="encode")
    protected boolean urlEncode;

    @Override
    public void traverse() {
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        if (this.getHeaderForReads() == null || this.getHeaderForReads().getReadGroups() == null) {
            throw new UserException.BadInput("The given input bam has no header or no read groups.  Cannot determine a sample name.");
        }
        List sampleNames = this.getHeaderForReads().getReadGroups().stream().map(s -> s.getSample()).distinct().collect(Collectors.toList());
        if (sampleNames.size() > 1) {
            throw new UserException.BadInput("The given input bam has more than one unique sample name: " + StringUtils.join(sampleNames, (String)", "));
        }
        if (sampleNames.size() == 0) {
            throw new UserException.BadInput("The given bam input has no sample names.");
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(this.outputSampleNameFile.getOutputStream());){
            String rawSample = (String)sampleNames.get(0);
            String outputSample = this.urlEncode ? IOUtils.urlEncode(rawSample) : rawSample;
            fileWriter.write(outputSample);
        }
        catch (IOException ioe) {
            throw new UserException(String.format("Could not write to output file %s.", this.outputSampleNameFile), ioe);
        }
    }
}

