/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import com.google.common.collect.Iterators;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionReadShardArgumentCollection;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerContext;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionWalkerSpark;
import org.broadinstitute.hellbender.engine.spark.FindAssemblyRegionsSpark;
import org.broadinstitute.hellbender.engine.spark.datasources.VariantsSparkSink;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="HaplotypeCaller on Spark", oneLineSummary="HaplotypeCaller on Spark", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class HaplotypeCallerSpark
extends AssemblyRegionWalkerSpark {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_READSHARD_SIZE = 5000;
    @Argument(fullName="output", shortName="O", doc="Single file to which variants should be written")
    public String output;
    @ArgumentCollection
    public HaplotypeCallerArgumentCollection hcArgs = new HaplotypeCallerArgumentCollection();

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return HaplotypeCallerEngine.getStandardHaplotypeCallerAnnotationGroups();
    }

    @Override
    public Collection<Annotation> makeVariantAnnotations() {
        boolean referenceConfidenceMode = this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE;
        Collection<Annotation> annotations = super.makeVariantAnnotations();
        return referenceConfidenceMode ? HaplotypeCallerEngine.filterReferenceConfidenceAnnotations(annotations) : annotations;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        if (this.output.endsWith(".bcf") || this.output.endsWith(".bcf.gz")) {
            throw new UserException.UnimplementedFeature("It is currently not possible to write a BCF file on spark.  See https://github.com/broadinstitute/gatk/issues/4303 for more details .");
        }
        Utils.validateArg(this.hcArgs.dbsnp.dbsnp == null, "HaplotypeCallerSpark does not yet support -D or --dbsnp arguments");
        Utils.validateArg(this.hcArgs.comps.isEmpty(), "HaplotypeCallerSpark does not yet support -comp or --comp arguments");
        Utils.validateArg(this.hcArgs.bamOutputPath == null, "HaplotypeCallerSpark does not yet support -bamout or --bamOutput");
        Utils.validate(this.getHeaderForReads().getSortOrder() == SAMFileHeader.SortOrder.coordinate, "The reads must be coordinate sorted.");
        this.logger.info("********************************************************************************");
        this.logger.info("The output of this tool DOES NOT match the output of HaplotypeCaller. ");
        this.logger.info("It is under development and should not be used for production work. ");
        this.logger.info("For evaluation only.");
        this.logger.info("Use the non-spark HaplotypeCaller if you care about the results. ");
        this.logger.info("********************************************************************************");
        try {
            super.runTool(ctx);
        }
        catch (Exception e) {
            if (e.getCause() instanceof UserException) {
                throw (UserException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    protected void processAssemblyRegions(JavaRDD<AssemblyRegionWalkerContext> rdd, JavaSparkContext ctx) {
        HaplotypeCallerSpark.processAssemblyRegions(rdd, ctx, this.getHeaderForReads(), this.referenceArguments.getReferenceFileName(), this.hcArgs, this.assemblyRegionArgs, this.output, this.makeVariantAnnotations(), this.logger, this.createOutputVariantIndex);
    }

    private static void processAssemblyRegions(JavaRDD<AssemblyRegionWalkerContext> rdd, JavaSparkContext ctx, SAMFileHeader header, String reference, HaplotypeCallerArgumentCollection hcArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, String output, Collection<Annotation> annotations, Logger logger, boolean createOutputVariantIndex) {
        VariantAnnotatorEngine variantannotatorEngine = new VariantAnnotatorEngine(annotations, hcArgs.dbsnp.dbsnp, hcArgs.comps, hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE, false);
        Path referencePath = IOUtils.getPath(reference);
        CachingIndexedFastaSequenceFile driverReferenceSequenceFile = new CachingIndexedFastaSequenceFile(referencePath);
        HaplotypeCallerEngine hcEngine = new HaplotypeCallerEngine(hcArgs, assemblyRegionArgs, false, false, header, driverReferenceSequenceFile, variantannotatorEngine);
        String referenceFileName = referencePath.getFileName().toString();
        Broadcast hcArgsBroadcast = ctx.broadcast((Object)hcArgs);
        Broadcast assemblyRegionArgsBroadcast = ctx.broadcast((Object)assemblyRegionArgs);
        Broadcast annotatorEngineBroadcast = ctx.broadcast((Object)variantannotatorEngine);
        JavaRDD variants = rdd.mapPartitions(HaplotypeCallerSpark.assemblyFunction(header, referenceFileName, (Broadcast<HaplotypeCallerArgumentCollection>)hcArgsBroadcast, (Broadcast<AssemblyRegionArgumentCollection>)assemblyRegionArgsBroadcast, (Broadcast<VariantAnnotatorEngine>)annotatorEngineBroadcast));
        try {
            VariantsSparkSink.writeVariants(ctx, output, (JavaRDD<VariantContext>)variants, hcEngine.makeVCFHeader(header.getSequenceDictionary(), new HashSet<VCFHeaderLine>()), hcArgs.emitReferenceConfidence == ReferenceConfidenceMode.GVCF, new ArrayList<Number>(hcArgs.GVCFGQBands), hcArgs.standardArgs.genotypeArgs.samplePloidy, 0, createOutputVariantIndex, false);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(output, "writing failed", (Exception)e);
        }
    }

    private static FlatMapFunction<Iterator<AssemblyRegionWalkerContext>, VariantContext> assemblyFunction(SAMFileHeader header, String referenceFileName, Broadcast<HaplotypeCallerArgumentCollection> hcArgsBroadcast, Broadcast<AssemblyRegionArgumentCollection> assemblyRegionArgsBroadcast, Broadcast<VariantAnnotatorEngine> annotatorEngineBroadcast) {
        return (FlatMapFunction & Serializable)contexts -> {
            ReferenceSequenceFile taskReferenceSequenceFile = HaplotypeCallerSpark.taskReferenceSequenceFile(referenceFileName);
            HaplotypeCallerEngine hcEngine = new HaplotypeCallerEngine((HaplotypeCallerArgumentCollection)hcArgsBroadcast.value(), (AssemblyRegionArgumentCollection)assemblyRegionArgsBroadcast.value(), false, false, header, taskReferenceSequenceFile, (VariantAnnotatorEngine)annotatorEngineBroadcast.getValue());
            Iterator iterators = Utils.stream(contexts).map(context -> {
                AssemblyRegion region = context.getAssemblyRegion();
                FeatureContext featureContext = context.getFeatureContext();
                return hcEngine.callRegion(region, featureContext, context.getReferenceContext()).iterator();
            }).iterator();
            return Iterators.concat(iterators);
        };
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return HaplotypeCallerEngine.makeStandardHCReadFilters();
    }

    @Override
    public AssemblyRegionEvaluator assemblyRegionEvaluator() {
        return null;
    }

    @Override
    protected Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast(JavaSparkContext ctx) {
        Path referencePath = IOUtils.getPath(this.referenceArguments.getReferenceFileName());
        String referenceFileName = referencePath.getFileName().toString();
        String pathOnExecutor = SparkFiles.get((String)referenceFileName);
        CachingIndexedFastaSequenceFile taskReferenceSequenceFile = new CachingIndexedFastaSequenceFile(IOUtils.getPath(pathOnExecutor));
        Collection<Annotation> annotations = this.makeVariantAnnotations();
        VariantAnnotatorEngine annotatorEngine = new VariantAnnotatorEngine(annotations, this.hcArgs.dbsnp.dbsnp, this.hcArgs.comps, this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE, false);
        return HaplotypeCallerSpark.assemblyRegionEvaluatorSupplierBroadcastFunction(ctx, this.hcArgs, this.assemblyRegionArgs, this.getHeaderForReads(), taskReferenceSequenceFile, annotatorEngine);
    }

    private static Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast(JavaSparkContext ctx, HaplotypeCallerArgumentCollection hcArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, SAMFileHeader header, String reference, Collection<Annotation> annotations) {
        Path referencePath = IOUtils.getPath(reference);
        String referenceFileName = referencePath.getFileName().toString();
        ReferenceSequenceFile taskReferenceSequenceFile = HaplotypeCallerSpark.taskReferenceSequenceFile(referenceFileName);
        VariantAnnotatorEngine annotatorEngine = new VariantAnnotatorEngine(annotations, hcArgs.dbsnp.dbsnp, hcArgs.comps, hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE, false);
        return HaplotypeCallerSpark.assemblyRegionEvaluatorSupplierBroadcastFunction(ctx, hcArgs, assemblyRegionArgs, header, taskReferenceSequenceFile, annotatorEngine);
    }

    private static ReferenceSequenceFile taskReferenceSequenceFile(String referenceFileName) {
        String pathOnExecutor = SparkFiles.get((String)referenceFileName);
        return new CachingIndexedFastaSequenceFile(IOUtils.getPath(pathOnExecutor));
    }

    private static Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcastFunction(JavaSparkContext ctx, final HaplotypeCallerArgumentCollection hcArgs, final AssemblyRegionArgumentCollection assemblyRegionArgs, final SAMFileHeader header, final ReferenceSequenceFile taskReferenceSequenceFile, final VariantAnnotatorEngine annotatorEngine) {
        Supplier<AssemblyRegionEvaluator> supplier = new Supplier<AssemblyRegionEvaluator>(){

            @Override
            public AssemblyRegionEvaluator get() {
                return new HaplotypeCallerEngine(hcArgs, assemblyRegionArgs, false, false, header, taskReferenceSequenceFile, annotatorEngine);
            }
        };
        return ctx.broadcast((Object)supplier);
    }

    public static void callVariantsWithHaplotypeCallerAndWriteOutput(JavaSparkContext ctx, JavaRDD<GATKRead> reads, SAMFileHeader header, SAMSequenceDictionary sequenceDictionary, String reference, List<ShardBoundary> intervalShards, HaplotypeCallerArgumentCollection hcArgs, AssemblyRegionReadShardArgumentCollection shardingArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, String output, Collection<Annotation> annotations, Logger logger, boolean strict, boolean createOutputVariantIndex) {
        Path referencePath = IOUtils.getPath(reference);
        String referenceFileName = referencePath.getFileName().toString();
        Broadcast<Supplier<AssemblyRegionEvaluator>> assemblyRegionEvaluatorSupplierBroadcast = HaplotypeCallerSpark.assemblyRegionEvaluatorSupplierBroadcast(ctx, hcArgs, assemblyRegionArgs, header, reference, annotations);
        JavaRDD<AssemblyRegionWalkerContext> assemblyRegions = strict ? FindAssemblyRegionsSpark.getAssemblyRegionsStrict(ctx, reads, header, sequenceDictionary, referenceFileName, null, intervalShards, assemblyRegionEvaluatorSupplierBroadcast, shardingArgs, assemblyRegionArgs, false) : FindAssemblyRegionsSpark.getAssemblyRegionsFast(ctx, reads, header, sequenceDictionary, referenceFileName, null, intervalShards, assemblyRegionEvaluatorSupplierBroadcast, shardingArgs, assemblyRegionArgs, false);
        HaplotypeCallerSpark.processAssemblyRegions(assemblyRegions, ctx, header, reference, hcArgs, assemblyRegionArgs, output, annotations, logger, createOutputVariantIndex);
    }
}

