/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetClass;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetErrorResponse;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetFormat;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetRequestBuilder;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetRequestField;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetResponse;
import org.broadinstitute.hellbender.utils.HttpUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@ExperimentalFeature
@CommandLineProgramProperties(summary="Download a file using htsget", oneLineSummary="Download a file using htsget", programGroup=ExampleProgramGroup.class)
public class HtsgetReader
extends CommandLineProgram {
    public static final String URL_LONG_NAME = "url";
    public static final String ID_LONG_NAME = "id";
    public static final String FORMAT_LONG_NAME = "format";
    public static final String CLASS_LONG_NAME = "class";
    public static final String FIELDS_LONG_NAME = "field";
    public static final String TAGS_LONG_NAME = "tag";
    public static final String NOTAGS_LONG_NAME = "notag";
    public static final String NUM_THREADS_LONG_NAME = "reader-threads";
    public static final String CHECK_MD5_LONG_NAME = "check-md5";
    @Argument(doc="Output file.", fullName="O", shortName="output")
    private File outputFile;
    @Argument(doc="URL of htsget endpoint.", fullName="url", shortName="url")
    private URI endpoint;
    @Argument(doc="ID of record to request.", fullName="id", shortName="id")
    private String id;
    @Argument(doc="Format to request record data in.", fullName="format", shortName="format", optional=true)
    private HtsgetFormat format;
    @Argument(doc="Class of data to request.", fullName="class", shortName="class", optional=true)
    private HtsgetClass dataClass;
    @Argument(doc="The interval and reference sequence to request", fullName="intervals", shortName="L", optional=true)
    private SimpleInterval interval;
    @Argument(doc="A field to include, default: all", fullName="field", shortName="field", optional=true)
    private List<HtsgetRequestField> fields;
    @Argument(doc="A tag which should be included.", fullName="tag", shortName="tag", optional=true)
    private List<String> tags;
    @Argument(doc="A tag which should be excluded.", fullName="notag", shortName="notag", optional=true)
    private List<String> notags;
    @Advanced
    @Argument(fullName="reader-threads", shortName="reader-threads", doc="How many simultaneous threads to use when reading data from an htsget response;higher values may improve performance when network latency is an issue.", optional=true, minValue=1.0)
    private int readerThreads = 1;
    @Argument(fullName="check-md5", shortName="check-md5", doc="Boolean determining whether to calculate the md5 digest of the assembled file and validate it against the provided md5 hash, if it exists.", optional=true)
    private boolean checkMd5 = false;
    private ExecutorService executorService;
    private CloseableHttpClient client;

    @Override
    public void onStartup() {
        if (this.readerThreads > 1) {
            this.logger.info("Initializing with " + this.readerThreads + " threads");
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("htsgetReader-thread-%d").setDaemon(true).build();
            this.executorService = Executors.newFixedThreadPool(this.readerThreads, threadFactory);
        }
        this.client = HttpUtils.getClient();
    }

    @Override
    public void onShutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        super.onShutdown();
    }

    private void getData(HtsgetResponse response) {
        try (FileOutputStream ostream = new FileOutputStream(this.outputFile);){
            response.getBlocks().forEach(b -> {
                try (InputStream istream = b.getData();){
                    IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                }
                catch (IOException e) {
                    throw new UserException("Failed to copy data block to output file", e);
                }
            });
        }
        catch (IOException e) {
            throw new UserException("Could not create output file: " + this.outputFile, e);
        }
    }

    private void getDataParallel(HtsgetResponse response) {
        ArrayList futures = new ArrayList(response.getBlocks().size());
        response.getBlocks().forEach(b -> futures.add(this.executorService.submit(b::getData)));
        try (FileOutputStream ostream = new FileOutputStream(this.outputFile);){
            futures.forEach(f -> {
                try (InputStream istream = (InputStream)f.get();){
                    IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                }
                catch (IOException e) {
                    throw new UserException("Error while copying data block to output file", e);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new UserException("Error while waiting to download block", e);
                }
            });
        }
        catch (IOException e) {
            throw new UserException("Could not create output file", e);
        }
    }

    private void checkMd5(HtsgetResponse resp) {
        String expectedMd5 = resp.getMd5();
        if (expectedMd5 == null) {
            this.logger.warn("No md5 digest provided by response");
        } else {
            try {
                String actualMd5 = Utils.calculateFileMD5(this.outputFile);
                if (!actualMd5.equals(expectedMd5)) {
                    throw new UserException("Expected md5: " + expectedMd5 + " did not match actual md5: " + actualMd5);
                }
            }
            catch (IOException e) {
                throw new UserException("Unable to calculate md5 digest", e);
            }
        }
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        return mapper;
    }

    @Override
    public Object doWork() {
        block20: {
            HtsgetRequestBuilder req = new HtsgetRequestBuilder(this.endpoint, this.id).withFormat(this.format).withDataClass(this.dataClass).withInterval(this.interval).withFields(this.fields).withTags(this.tags).withNotags(this.notags);
            URI reqURI = req.toURI();
            HttpGet getReq = new HttpGet(reqURI);
            try (CloseableHttpResponse resp = this.client.execute((HttpUriRequest)getReq);){
                HttpEntity entity = resp.getEntity();
                Header encodingHeader = entity.getContentEncoding();
                Charset encoding = encodingHeader == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)encodingHeader.getValue());
                String jsonBody = EntityUtils.toString((HttpEntity)entity, (Charset)encoding);
                ObjectMapper mapper = this.getObjectMapper();
                if (resp.getStatusLine() == null) {
                    throw new UserException(String.format("htsget server response did not contain status line for request %s", reqURI));
                }
                int statusCode = resp.getStatusLine().getStatusCode();
                if (400 <= statusCode && statusCode < 500) {
                    HtsgetErrorResponse err = (HtsgetErrorResponse)mapper.readValue(jsonBody, HtsgetErrorResponse.class);
                    throw new UserException(String.format("Invalid request %s, received error code: %d, error type: %s, message: %s", reqURI, statusCode, err.getError(), err.getMessage()));
                }
                if (statusCode == 200) {
                    HtsgetResponse response = (HtsgetResponse)mapper.readValue(jsonBody, HtsgetResponse.class);
                    if (this.readerThreads > 1) {
                        this.getDataParallel(response);
                    } else {
                        this.getData(response);
                    }
                    this.logger.info("Successfully wrote to: " + this.outputFile);
                    if (this.checkMd5) {
                        this.checkMd5(response);
                    }
                    break block20;
                }
                throw new UserException(String.format("Unrecognized status code: %d for request %s", statusCode, reqURI));
            }
            catch (IOException e) {
                throw new UserException(String.format("IOException during htsget download for %s", reqURI), e);
            }
        }
        return null;
    }
}

