/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.tabix.TabixIndex;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.codecs.ProgressReportingDelegatingCodec;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="Creates an index for a feature file, e.g. VCF or BED file.", oneLineSummary="Creates an index for a feature file, e.g. VCF or BED file.", programGroup=OtherProgramGroup.class)
@DocumentedFeature
public final class IndexFeatureFile
extends CommandLineProgram {
    private static final Logger logger = LogManager.getLogger(IndexFeatureFile.class);
    @Argument(shortName="I", fullName="input", doc="Feature file (eg., VCF or BED file) to index. Must be in a tribble-supported format")
    public GATKPath featurePath;
    @Argument(shortName="O", fullName="output", doc="The output index file. If missing, the tool will create an index file in the same directory as the input file.", optional=true)
    public GATKPath outputPath;
    public static final int OPTIMAL_GVCF_INDEX_BIN_SIZE = 128000;
    public static final String GVCF_FILE_EXTENSION = ".g.vcf";

    @Override
    protected Object doWork() {
        if (!Files.isReadable(this.featurePath.toPath())) {
            throw new UserException.CouldNotReadInputFile(this.featurePath.toPath());
        }
        ProgressReportingDelegatingCodec codec = new ProgressReportingDelegatingCodec(FeatureManager.getCodecForFile(this.featurePath.toPath()), 10.0);
        Index index = this.createAppropriateIndexInMemory(codec);
        Path indexPath = this.determineFileName(index);
        try {
            index.write(indexPath);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Could not write index to file " + indexPath, (Exception)e);
        }
        logger.info("Successfully wrote index to " + indexPath);
        return indexPath.toString();
    }

    private Path determineFileName(Index index) {
        if (this.outputPath != null) {
            return this.outputPath.toPath();
        }
        if (index instanceof TabixIndex) {
            return Tribble.tabixIndexPath((Path)this.featurePath.toPath());
        }
        return Tribble.indexPath((Path)this.featurePath.toPath());
    }

    private Index createAppropriateIndexInMemory(FeatureCodec<? extends Feature, ?> codec) {
        try {
            if (IOUtil.hasBlockCompressedExtension((Path)this.featurePath.toPath())) {
                if (this.outputPath != null && !this.outputPath.getURIString().endsWith(".tbi")) {
                    throw new UserException("The index for " + this.featurePath + " must be written to a file with a \"" + ".tbi" + "\" extension");
                }
                return IndexFactory.createIndex((Path)this.featurePath.toPath(), codec, (IndexFactory.IndexType)IndexFactory.IndexType.TABIX, null);
            }
            if (this.featurePath.getURIString().endsWith(GVCF_FILE_EXTENSION)) {
                return IndexFactory.createLinearIndex((Path)this.featurePath.toPath(), codec, (int)128000);
            }
            return IndexFactory.createDynamicIndex((Path)this.featurePath.toPath(), codec, (IndexFactory.IndexBalanceApproach)IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
        }
        catch (TribbleException e) {
            throw new UserException.CouldNotIndexFile(this.featurePath.toPath(), (Exception)((Object)e));
        }
    }
}

