/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.CigarBuilder;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Left-aligns indels from reads in a SAM/BAM/CRAM file.", oneLineSummary="Left-aligns indels from reads in a SAM/BAM/CRAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class LeftAlignIndels
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Output BAM")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    private GATKPath output;
    private SAMFileGATKReadWriter outputWriter = null;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.output, true);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext ref, FeatureContext featureContext) {
        if (read.isUnmapped() || read.numCigarElements() <= 1) {
            this.outputWriter.addRead(read);
            return;
        }
        CigarBuilder.Result result = AlignmentUtils.leftAlignIndels(read.getCigar(), ref.getBases(), read.getBases(), 0);
        read.setCigar(result.getCigar());
        if (result.getLeadingDeletionBasesRemoved() > 0) {
            read.setPosition(read.getContig(), read.getStart() + result.getLeadingDeletionBasesRemoved());
        }
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

