/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.util.IOUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import picard.cmdline.programgroups.OtherProgramGroup;

@ExperimentalFeature
@CommandLineProgramProperties(summary="Print information about the compressed blocks in a BGZF format file", oneLineSummary="Print information about the compressed blocks in a BGZF format file", programGroup=OtherProgramGroup.class)
public class PrintBGZFBlockInformation
extends CommandLineProgram {
    @Argument(fullName="bgzf-file", doc="The BGZF-format file for which to print block information", optional=false)
    private String bgzfPathString;
    @Argument(fullName="output", shortName="O", doc="File to which to write block information (if not specified, prints to standard output)", optional=true)
    private String output;
    private Path bgzfPath;
    private long streamOffset = 0L;
    private PrintStream outStream;

    @Override
    protected void onStartup() {
        super.onStartup();
        this.bgzfPath = IOUtils.getPath(this.bgzfPathString);
        if (!Files.exists(this.bgzfPath, new LinkOption[0])) {
            throw new UserException.CouldNotReadInputFile("File " + this.bgzfPathString + " does not exist");
        }
        try {
            if (!IOUtil.isBlockCompressed((Path)this.bgzfPath)) {
                throw new UserException.CouldNotReadInputFile(this.bgzfPath, "File is not a valid BGZF file. Could be a regular GZIP file, or some other non-BGZF format.");
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.bgzfPath, "Unable to determine whether file is a valid BGZF file", (Throwable)e);
        }
        if (this.output != null) {
            try {
                this.outStream = new PrintStream(this.output);
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotCreateOutputFile(this.output, "Unable to open output file", (Exception)e);
            }
        } else {
            this.outStream = System.out;
        }
    }

    @Override
    protected Object doWork() {
        BGZFBlockMetadata previousBlockInfo = null;
        int blockNumber = 0;
        ArrayList<Integer> nonFinalTerminatorBlockIndices = new ArrayList<Integer>();
        try (InputStream bgzfInputStream = Files.newInputStream(this.bgzfPath, new OpenOption[0]);){
            BGZFBlockMetadata blockInfo;
            this.outStream.printf("BGZF block information for file: %s\n\n", this.bgzfPath.getFileName());
            while ((blockInfo = this.processNextBlock(bgzfInputStream, this.bgzfPathString)) != null) {
                ++blockNumber;
                if (previousBlockInfo != null && previousBlockInfo.uncompressedSize == 0) {
                    nonFinalTerminatorBlockIndices.add(blockNumber - 1);
                    this.outStream.println("*******************************************************");
                    this.outStream.println("ERROR: Premature BGZF 0-byte terminator block was found");
                    this.outStream.println("at block number: " + (blockNumber - 1));
                    this.outStream.println("*******************************************************");
                    this.outStream.println();
                }
                this.outStream.printf("Block #%d at file offset %d\n", blockNumber, blockInfo.blockOffset);
                this.outStream.printf("\t- compressed size: %d\n", blockInfo.compressedSize);
                this.outStream.printf("\t- uncompressed size: %d\n", blockInfo.uncompressedSize);
                this.outStream.println();
                previousBlockInfo = blockInfo;
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile("Error while parsing BGZF file.", (Exception)e);
        }
        if (previousBlockInfo == null || previousBlockInfo.uncompressedSize != 0) {
            this.outStream.println("******************************************************");
            this.outStream.println("ERROR: Final BGZF 0-byte terminator block was MISSING!");
            this.outStream.println("******************************************************");
            this.outStream.println();
        } else {
            this.outStream.println("***************************************************************************");
            this.outStream.println("Final BGZF 0-byte terminator block FOUND as expected at block number " + blockNumber);
            this.outStream.println("***************************************************************************");
            this.outStream.println();
        }
        if (!nonFinalTerminatorBlockIndices.isEmpty()) {
            this.outStream.println("***********************************************************");
            this.outStream.println("ERROR: Premature BGZF 0-byte terminator block(s) were found");
            this.outStream.println("at block number(s): " + StringUtils.join(nonFinalTerminatorBlockIndices, (String)","));
            this.outStream.println("***********************************************************");
            this.outStream.println();
        }
        return 0;
    }

    @Override
    protected void onShutdown() {
        if (this.outStream != null && this.outStream != System.out) {
            this.outStream.close();
        }
    }

    private BGZFBlockMetadata processNextBlock(InputStream stream, String streamSource) throws IOException {
        byte[] buffer = new byte[65536];
        long blockAddress = this.streamOffset;
        int headerByteCount = PrintBGZFBlockInformation.readBytes(stream, buffer, 0, 18);
        if (headerByteCount <= 0) {
            return null;
        }
        if (headerByteCount != 18) {
            throw new IOException("Incorrect header size for file: " + streamSource);
        }
        this.streamOffset += (long)headerByteCount;
        int blockLength = PrintBGZFBlockInformation.unpackInt16(buffer, 16) + 1;
        if (blockLength < 18 || blockLength > buffer.length) {
            throw new IOException("Unexpected compressed block length: " + blockLength + " for " + streamSource);
        }
        int remaining = blockLength - 18;
        int dataByteCount = PrintBGZFBlockInformation.readBytes(stream, buffer, 18, remaining);
        if (dataByteCount != remaining) {
            throw new IOException("Premature end of file: " + streamSource);
        }
        this.streamOffset += (long)dataByteCount;
        int uncompressedLength = PrintBGZFBlockInformation.unpackInt32(buffer, blockLength - 4);
        if (uncompressedLength < 0) {
            throw new IOException(streamSource + " has invalid uncompressed length: " + uncompressedLength);
        }
        return new BGZFBlockMetadata(blockAddress, blockLength, uncompressedLength);
    }

    private static int unpackInt16(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8;
    }

    private static int unpackInt32(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    private static int readBytes(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length; bytesRead += count) {
            count = stream.read(buffer, offset + bytesRead, length - bytesRead);
            if (count < 0 && bytesRead == 0) {
                return count;
            }
            if (count <= 0) break;
        }
        return bytesRead;
    }

    private static final class BGZFBlockMetadata {
        private final long blockOffset;
        private final int compressedSize;
        private final int uncompressedSize;

        public BGZFBlockMetadata(long blockOffset, int compressedSize, int uncompressedSize) {
            this.blockOffset = blockOffset;
            this.compressedSize = compressedSize;
            this.uncompressedSize = uncompressedSize;
        }
    }
}

