/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Prints reads from the input SAM/BAM/CRAM file to the SAM/BAM/CRAM file.", oneLineSummary="Print reads in the SAM/BAM/CRAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class PrintReads
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath output;
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.output, true);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

