/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.exceptions.UserException;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Prints the header from the input SAM/BAM/CRAM file to a textual output file", oneLineSummary="Print the header from a SAM/BAM/CRAM file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class PrintReadsHeader
extends GATKTool {
    @Argument(fullName="output", shortName="O", doc="file to write the bam header to", optional=false)
    private GATKPath outputFile;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public void traverse() {
        SAMFileHeader bamHeader = this.getHeaderForReads();
        try (OutputStreamWriter outputWriter = new OutputStreamWriter(this.outputFile.getOutputStream());){
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            codec.encode((Writer)outputWriter, bamHeader);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Error writing reads header to " + this.outputFile, (Exception)e);
        }
        this.logger.info("Successfully wrote reads header to destination: " + this.outputFile);
    }
}

