/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.IOUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.readersplitters.LibraryNameSplitter;
import org.broadinstitute.hellbender.tools.readersplitters.ReadGroupIdSplitter;
import org.broadinstitute.hellbender.tools.readersplitters.ReaderSplitter;
import org.broadinstitute.hellbender.tools.readersplitters.SampleNameSplitter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Outputs reads from a SAM/BAM/CRAM by read group, sample and library name", oneLineSummary="Outputs reads from a SAM/BAM/CRAM by read group, sample and library name", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class SplitReads
extends ReadWalker {
    public static final String SAMPLE_SHORT_NAME = "SM";
    public static final String READ_GROUP_SHORT_NAME = "RG";
    public static final String LIBRARY_NAME_SHORT_NAME = "LB";
    public static final String SAMPLE_LONG_NAME = "split-sample";
    public static final String READ_GROUP_LONG_NAME = "split-read-group";
    public static final String LIBRARY_NAME_LONG_NAME = "split-library-name";
    public static final String UNKNOWN_OUT_PREFIX = "unknown";
    @Argument(shortName="O", fullName="output", doc="The directory to output SAM/BAM/CRAM files.")
    @WorkflowOutput
    public GATKPath OUTPUT_DIRECTORY;
    @Argument(fullName="split-sample", shortName="SM", doc="Split file by sample.")
    public boolean SAMPLE;
    @Argument(fullName="split-read-group", shortName="RG", doc="Split file by read group.")
    public boolean READ_GROUP;
    @Argument(fullName="split-library-name", shortName="LB", doc="Split file by library.")
    public boolean LIBRARY_NAME;
    private final List<ReaderSplitter<?>> splitters = new ArrayList();
    private Map<String, SAMFileGATKReadWriter> outs = null;

    @Override
    public void onTraversalStart() {
        IOUtil.assertDirectoryIsWritable((Path)this.OUTPUT_DIRECTORY.toPath());
        if (this.readArguments.getReadPathSpecifiers().size() != 1) {
            throw new UserException("This tool only accepts a single SAM/BAM/CRAM as input");
        }
        if (this.SAMPLE) {
            this.splitters.add(new SampleNameSplitter());
        }
        if (this.READ_GROUP) {
            this.splitters.add(new ReadGroupIdSplitter());
        }
        if (this.LIBRARY_NAME) {
            this.splitters.add(new LibraryNameSplitter());
        }
        this.outs = this.createWriters(this.splitters);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outs.computeIfAbsent(this.getKey(this.splitters, read), this::createUnknownOutOnDemand).addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outs != null) {
            this.outs.values().forEach(writer -> writer.close());
        }
    }

    private SAMFileGATKReadWriter createUnknownOutOnDemand(String attributeValue) {
        if (!attributeValue.equals(".unknown")) {
            throw new GATKException.ShouldNeverReachHereException("Unrecognized attribute value found: " + attributeValue);
        }
        return this.prepareSAMFileWriter(attributeValue);
    }

    private SAMFileGATKReadWriter prepareSAMFileWriter(String keyName) {
        GATKPath pathSpec = this.readArguments.getReadPathSpecifiers().get(0);
        GATKPath outFile = new GATKPath(this.OUTPUT_DIRECTORY.toPath().resolve(pathSpec.getBaseName().orElse("") + keyName + (String)pathSpec.getExtension().get()).toString());
        return this.createSAMWriter(outFile, true);
    }

    private Map<String, SAMFileGATKReadWriter> createWriters(List<ReaderSplitter<?>> splitters) {
        LinkedHashMap<String, SAMFileGATKReadWriter> outs = new LinkedHashMap<String, SAMFileGATKReadWriter>();
        SAMFileHeader samFileHeaderIn = this.getHeaderForReads();
        List<List<?>> splitKeys = splitters.stream().map(splitter -> splitter.getSplitsBy(samFileHeaderIn)).collect(Collectors.toList());
        this.addKey(splitKeys, 0, "", key -> outs.put((String)key, this.prepareSAMFileWriter((String)key)));
        return outs;
    }

    private void addKey(List<List<?>> listKeys, int listIndex, String key, Consumer<String> adder) {
        if (listIndex < listKeys.size()) {
            for (Object newKey : listKeys.get(listIndex)) {
                this.addKey(listKeys, listIndex + 1, key + "." + newKey, adder);
            }
        } else {
            adder.accept(key);
        }
    }

    private String getKey(List<ReaderSplitter<?>> splitters, GATKRead record) {
        return splitters.stream().map(s -> {
            Object key = s.getSplitBy(record, this.getHeaderForReads());
            return key == null ? UNKNOWN_OUT_PREFIX : key.toString();
        }).reduce("", (acc, item) -> acc + "." + item);
    }
}

