/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.AnnotatedVariantProducer;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.ContigChimericAlignmentIterativeInterpreter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantCanonicalRepresentation;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantInducingAssemblyContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantInterpreter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SegmentedCpxVariantSimpleVariantExtractor;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleNovelAdjacencyAndChimericAlignmentEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.utils.CNVInputReader;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVVCFWriter;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Examines aligned contigs from local assemblies and calls structural variants or their breakpoints", summary="This tool takes a file containing the alignments of assembled contigs and searches it for contigs with split alignments or large gaps indicating the presence of structural variation breakpoints. Variations' types are determined by analyzing the signatures of the split alignments, and are written to a VCF file.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
public class StructuralVariantDiscoverer
extends ReadWalker {
    @Argument(doc="Name of output VCF.", shortName="O", fullName="outputVCFName")
    private String outputVCFName;
    @Argument(doc="file containing non-canonical chromosome names (e.g chrUn_KI270588v1) in the reference, human reference (hg19 or hg38) assumed when omitted", shortName="alt-tigs", fullName="non-canonical-contig-names-file", optional=true)
    private String nonCanonicalChromosomeNamesFile;
    @ArgumentCollection
    private final StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs = new StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection();
    private static final double SCORE_DIFF_TOLERANCE = 0.0;
    private String sampleId;
    private SAMSequenceDictionary refDict;
    private BasicReference reference;
    private SVIntervalTree<VariantContext> cnvCalls;
    private Set<String> canonicalChromosomes;
    private String currentContigName = null;
    private final List<GATKRead> readsForCurrentContig = new ArrayList<GATKRead>();
    private final Map<NovelAdjacencyAndAltHaplotype, SimpleNovelAdjacencyAndChimericAlignmentEvidence> simpleEvidenceForNovelAdjacencyMap = new HashMap<NovelAdjacencyAndAltHaplotype, SimpleNovelAdjacencyAndChimericAlignmentEvidence>(10000);
    private final Map<CpxVariantCanonicalRepresentation, List<CpxVariantInducingAssemblyContig>> complexEventContigsMap = new HashMap<CpxVariantCanonicalRepresentation, List<CpxVariantInducingAssemblyContig>>(1000);
    private final List<AlignedContig> complexContigs = new ArrayList<AlignedContig>(1000);

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Arrays.asList(ReadFilterLibrary.MAPPED, ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
    }

    @Override
    public void onTraversalStart() {
        SAMFileHeader header = this.getHeaderForReads();
        if (header.getSortOrder() != SAMFileHeader.SortOrder.queryname) {
            throw new UserException("This tool requires a queryname-sorted source of reads.");
        }
        this.sampleId = SVUtils.getSampleId(header);
        this.refDict = header.getSequenceDictionary();
        this.cnvCalls = this.discoverStageArgs.cnvCallsFile == null ? null : CNVInputReader.loadCNVCalls(this.discoverStageArgs.cnvCallsFile, header);
        this.canonicalChromosomes = SVUtils.getCanonicalChromosomes(this.nonCanonicalChromosomeNamesFile, this.refDict);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.reference = referenceContext;
        String contigName = read.getName();
        if (!contigName.equals(this.currentContigName)) {
            if (!this.readsForCurrentContig.isEmpty()) {
                this.processContigAlignments(this.readsForCurrentContig);
                this.readsForCurrentContig.clear();
            }
            this.currentContigName = contigName;
        }
        this.readsForCurrentContig.add(read);
    }

    @Override
    public Object onTraversalSuccess() {
        Object result = super.onTraversalSuccess();
        if (!this.readsForCurrentContig.isEmpty()) {
            this.processContigAlignments(this.readsForCurrentContig);
        }
        ArrayList<VariantContext> variants = new ArrayList<VariantContext>(2 * this.simpleEvidenceForNovelAdjacencyMap.size());
        Collection<SimpleNovelAdjacencyAndChimericAlignmentEvidence> simpleEvidence = this.simpleEvidenceForNovelAdjacencyMap.values();
        for (SimpleNovelAdjacencyAndChimericAlignmentEvidence novelAdjacencyAndEvidence : simpleEvidence) {
            List<SvType> svTypes = novelAdjacencyAndEvidence.getNovelAdjacencyReferenceLocations().toSimpleOrBNDTypes(this.reference);
            variants.addAll(novelAdjacencyAndEvidence.toVariantContexts(svTypes, this.sampleId, this.refDict, this.cnvCalls));
        }
        SegmentedCpxVariantSimpleVariantExtractor.ZeroAndOneSegmentCpxVariantExtractor zeroAndOneSegmentCpxVariantExtractor = new SegmentedCpxVariantSimpleVariantExtractor.ZeroAndOneSegmentCpxVariantExtractor();
        ArrayList<Object> multiSegmentVariants = new ArrayList<Object>(this.complexEventContigsMap.size());
        for (Map.Entry entry : this.complexEventContigsMap.entrySet()) {
            Object variantContext = CpxVariantInterpreter.toVariantContext((CpxVariantCanonicalRepresentation)entry.getKey(), (Iterable)entry.getValue(), this.reference);
            int refSegs = SVUtils.getAttributeAsStringList((VariantContext)variantContext, "SEGMENTS").size();
            if (refSegs < 2) {
                variants.addAll(zeroAndOneSegmentCpxVariantExtractor.extract((VariantContext)variantContext, this.reference));
                continue;
            }
            multiSegmentVariants.add(variantContext);
        }
        HashMap<String, SegmentedCpxVariantSimpleVariantExtractor.RelevantAttributes> contigNameToCpxVariantAttributes = new HashMap<String, SegmentedCpxVariantSimpleVariantExtractor.RelevantAttributes>(2 * multiSegmentVariants.size());
        for (Object variantContext : multiSegmentVariants) {
            SegmentedCpxVariantSimpleVariantExtractor.RelevantAttributes relevantAttributes = new SegmentedCpxVariantSimpleVariantExtractor.RelevantAttributes((VariantContext)variantContext);
            for (String string : SVUtils.getAttributeAsStringList((VariantContext)variantContext, "CTG_NAMES")) {
                contigNameToCpxVariantAttributes.put(string, relevantAttributes);
            }
        }
        HashMap hashMap = new HashMap();
        for (AlignedContig alignedContig : this.complexContigs) {
            if (!contigNameToCpxVariantAttributes.containsKey(alignedContig.getContigName()) || alignedContig.getAlignments().size() <= 1) continue;
            List<SimpleChimera> chimeras = ContigChimericAlignmentIterativeInterpreter.parseOneContig(alignedContig, this.refDict, true, 50, 60, true);
            for (SimpleChimera simpleChimera : chimeras) {
                NovelAdjacencyAndAltHaplotype novelAdjacency = new NovelAdjacencyAndAltHaplotype(simpleChimera, alignedContig.getContigSequence(), this.refDict);
                List chimerasForNovelAdjacency = (List)hashMap.get(novelAdjacency);
                if (chimerasForNovelAdjacency != null) {
                    chimerasForNovelAdjacency.add(simpleChimera);
                    continue;
                }
                ArrayList<SimpleChimera> newList = new ArrayList<SimpleChimera>(2);
                newList.add(simpleChimera);
                hashMap.put(novelAdjacency, newList);
            }
        }
        ArrayList<VariantContext> reinterpretedVariants = new ArrayList<VariantContext>(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            reinterpretedVariants.add(new SimpleNovelAdjacencyAndChimericAlignmentEvidence((NovelAdjacencyAndAltHaplotype)entry.getKey(), (Iterable)entry.getValue()).produceAnnotatedVcFromAssemblyEvidence(ContigChimericAlignmentIterativeInterpreter.inferSimpleTypeFromNovelAdjacency((NovelAdjacencyAndAltHaplotype)entry.getKey(), this.reference), this.refDict, this.cnvCalls, this.sampleId).make());
        }
        ArrayList<VariantContext> extractedMultiSegmentVariants = new ArrayList<VariantContext>(multiSegmentVariants.size());
        SegmentedCpxVariantSimpleVariantExtractor.MultiSegmentsCpxVariantExtractor multiSegmentsCpxVariantExtractor = new SegmentedCpxVariantSimpleVariantExtractor.MultiSegmentsCpxVariantExtractor();
        for (VariantContext variantContext : multiSegmentVariants) {
            extractedMultiSegmentVariants.addAll(multiSegmentsCpxVariantExtractor.extract(variantContext, this.reference));
        }
        List<VariantContext> list = SegmentedCpxVariantSimpleVariantExtractor.filterForConsistency(reinterpretedVariants, contigNameToCpxVariantAttributes, this.reference);
        variants.addAll(SegmentedCpxVariantSimpleVariantExtractor.removeDuplicates(extractedMultiSegmentVariants, list));
        List<VariantContext> list2 = AnnotatedVariantProducer.filterMergedVariantList(variants, this.discoverStageArgs);
        SVVCFWriter.writeVCF(list2, this.outputVCFName, this.refDict, this.getDefaultToolVCFHeaderLines(), this.logger);
        return result;
    }

    private void processContigAlignments(List<GATKRead> contigAlignments) {
        ArrayList<AlignmentInterval> alignmentIntervals = new ArrayList<AlignmentInterval>(contigAlignments.size());
        String contigName = null;
        byte[] contigSequence = null;
        for (GATKRead read : contigAlignments) {
            contigName = read.getName();
            if (!read.isSupplementaryAlignment()) {
                contigSequence = read.getBasesNoCopy();
                if (read.isReverseStrand()) {
                    contigSequence = BaseUtils.simpleReverseComplement(contigSequence);
                }
            }
            alignmentIntervals.add(new AlignmentInterval(read));
        }
        if (contigSequence == null) {
            throw new UserException("No primary line for " + contigName);
        }
        AlignedContig alignedContig = new AlignedContig(contigName, contigSequence, alignmentIntervals);
        if (!alignedContig.hasGoodMQ()) {
            return;
        }
        List<AssemblyContigWithFineTunedAlignments> fineTunedAlignmentsList = alignedContig.reconstructContigFromBestConfiguration(this.canonicalChromosomes, 0.0);
        for (AssemblyContigWithFineTunedAlignments fineTunedAlignment : fineTunedAlignmentsList) {
            if (fineTunedAlignment.getAlignmentSignatureBasicType() == AssemblyContigWithFineTunedAlignments.AlignmentSignatureBasicType.SIMPLE_CHIMERA) {
                if (!SimpleChimera.splitPairStrongEnoughEvidenceForCA(fineTunedAlignment.getHeadAlignment(), fineTunedAlignment.getTailAlignment())) continue;
                SimpleChimera simpleChimera = fineTunedAlignment.extractSimpleChimera(this.refDict);
                NovelAdjacencyAndAltHaplotype novelAdjacency = new NovelAdjacencyAndAltHaplotype(simpleChimera, fineTunedAlignment.getContigSequence(), this.refDict);
                SimpleNovelAdjacencyAndChimericAlignmentEvidence simpleEvidence = this.simpleEvidenceForNovelAdjacencyMap.get(novelAdjacency);
                if (simpleEvidence != null) {
                    simpleEvidence.getAlignmentEvidence().add(simpleChimera);
                    continue;
                }
                SimpleNovelAdjacencyAndChimericAlignmentEvidence novelAdjacencyEvidence = new SimpleNovelAdjacencyAndChimericAlignmentEvidence(novelAdjacency, Collections.singletonList(simpleChimera));
                this.simpleEvidenceForNovelAdjacencyMap.put(novelAdjacency, novelAdjacencyEvidence);
                continue;
            }
            if (fineTunedAlignment.getAlignmentSignatureBasicType() != AssemblyContigWithFineTunedAlignments.AlignmentSignatureBasicType.COMPLEX) continue;
            this.complexContigs.add(fineTunedAlignment.getSourceContig());
            Tuple2<CpxVariantCanonicalRepresentation, CpxVariantInducingAssemblyContig> entry = CpxVariantInterpreter.getOneVariantFromOneContig(fineTunedAlignment, this.refDict);
            List<CpxVariantInducingAssemblyContig> contigsList = this.complexEventContigsMap.get(entry._1);
            if (contigsList != null) {
                contigsList.add((CpxVariantInducingAssemblyContig)entry._2);
                continue;
            }
            ArrayList<Object> newList = new ArrayList<Object>(2);
            newList.add(entry._2);
            this.complexEventContigsMap.put((CpxVariantCanonicalRepresentation)entry._1, newList);
        }
    }
}

