/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.bed.BEDFeature;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.AnnotatedIntervalCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SimpleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationKey;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.AnnotationMap;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.annotation.CopyNumberAnnotations;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.SimpleInterval;

@CommandLineProgramProperties(summary="Annotates intervals with GC content, mappability, and segmental-duplication content", oneLineSummary="Annotates intervals with GC content, mappability, and segmental-duplication content", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class AnnotateIntervals
extends GATKTool {
    private static final int DEFAULT_FEATURE_QUERY_LOOKAHEAD_IN_BP = 1000000;
    public static final String MAPPABILITY_TRACK_PATH_LONG_NAME = "mappability-track";
    public static final String SEGMENTAL_DUPLICATION_TRACK_PATH_LONG_NAME = "segmental-duplication-track";
    public static final String FEATURE_QUERY_LOOKAHEAD = "feature-query-lookahead";
    @Argument(doc="Output file for annotated intervals.", fullName="output", shortName="O")
    private File outputAnnotatedIntervalsFile;
    @Argument(doc="Path to Umap single-read mappability track in .bed or .bed.gz format (see https://bismap.hoffmanlab.org/).  Overlapping intervals must be merged.", fullName="mappability-track", optional=true)
    private FeatureInput<BEDFeature> mappabilityTrackPath;
    @Argument(doc="Path to segmental-duplication track in .bed or .bed.gz format.  Overlapping intervals must be merged.", fullName="segmental-duplication-track", optional=true)
    private FeatureInput<BEDFeature> segmentalDuplicationTrackPath;
    @Argument(doc="Number of bases to cache when querying feature tracks.", fullName="feature-query-lookahead", optional=true)
    private int featureQueryLookahead = 1000000;
    private List<SimpleInterval> intervals;
    private SAMSequenceDictionary sequenceDictionary;
    private ReferenceDataSource reference;
    private FeatureManager features;
    private List<IntervalAnnotator<?>> annotators = new ArrayList();
    private AnnotatedIntervalCollection annotatedIntervals;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        this.validateArguments();
        this.logger.info("Loading intervals for annotation...");
        this.sequenceDictionary = this.getBestAvailableSequenceDictionary();
        this.intervals = this.intervalArgumentCollection.getIntervals(this.sequenceDictionary);
        this.logger.info("Loading resources for annotation...");
        this.reference = ReferenceDataSource.of(this.referenceArguments.getReferencePath());
        this.features = new FeatureManager(this, this.featureQueryLookahead, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        this.logger.info("Adding GC-content annotator...");
        this.annotators.add(new GCContentAnnotator());
        if (this.mappabilityTrackPath != null) {
            AnnotateIntervals.checkForOverlaps(this.features, this.mappabilityTrackPath, this.sequenceDictionary);
            this.logger.info("Adding mappability annotator...");
            this.annotators.add(new MappabilityAnnotator(this.mappabilityTrackPath));
        }
        if (this.segmentalDuplicationTrackPath != null) {
            AnnotateIntervals.checkForOverlaps(this.features, this.segmentalDuplicationTrackPath, this.sequenceDictionary);
            this.logger.info("Adding segmental-duplication-content annotator...");
            this.annotators.add(new SegmentalDuplicationContentAnnotator(this.segmentalDuplicationTrackPath));
        }
        this.logger.info("Annotating intervals...");
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateIntervalArgumentCollection(this.intervalArgumentCollection);
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputAnnotatedIntervalsFile);
    }

    private static void checkForOverlaps(FeatureManager featureManager, FeatureInput<BEDFeature> featureTrackPath, SAMSequenceDictionary sequenceDictionary) {
        List features = IteratorUtils.toList(featureManager.getFeatureIterator(featureTrackPath));
        GenomeLocParser parser = new GenomeLocParser(sequenceDictionary);
        List<GenomeLoc> genomeLocs = IntervalUtils.genomeLocsFromLocatables(parser, features);
        List<GenomeLoc> mergedGenomeLocs = IntervalUtils.mergeIntervalLocations(genomeLocs, IntervalMergingRule.OVERLAPPING_ONLY);
        if (genomeLocs.size() != mergedGenomeLocs.size()) {
            throw new UserException.BadInput(String.format("Feature track %s contains overlapping intervals; these should be merged.", featureTrackPath));
        }
    }

    @Override
    public void traverse() {
        ArrayList<AnnotatedInterval> annotatedIntervalList = new ArrayList<AnnotatedInterval>(this.intervals.size());
        for (SimpleInterval interval : this.intervals) {
            if (interval.getLengthOnReference() == 0) {
                throw new UserException.BadInput(String.format("Interval cannot have zero length: %s", interval));
            }
            ReferenceContext referenceContext = new ReferenceContext(this.reference, interval);
            FeatureContext featureContext = new FeatureContext(this.features, interval);
            AnnotationMap annotations = new AnnotationMap(this.annotators.stream().collect(Collectors.mapping(a -> Pair.of(a.getAnnotationKey(), a.applyAndValidate(interval, referenceContext, featureContext)), Collectors.toList())));
            annotatedIntervalList.add(new AnnotatedInterval(interval, annotations));
            this.progressMeter.update(interval);
        }
        this.annotatedIntervals = new AnnotatedIntervalCollection(new SimpleLocatableMetadata(this.sequenceDictionary), annotatedIntervalList);
    }

    @Override
    public Object onTraversalSuccess() {
        this.reference.close();
        this.features.close();
        this.logger.info(String.format("Writing annotated intervals to %s...", this.outputAnnotatedIntervalsFile.getAbsolutePath()));
        this.annotatedIntervals.write(this.outputAnnotatedIntervalsFile);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return super.onTraversalSuccess();
    }

    private static class SegmentalDuplicationContentAnnotator
    extends BEDLengthWeightedAnnotator {
        SegmentalDuplicationContentAnnotator(FeatureInput<BEDFeature> segmentalDuplicationTrackPath) {
            super(segmentalDuplicationTrackPath);
        }

        @Override
        public AnnotationKey<Double> getAnnotationKey() {
            return CopyNumberAnnotations.SEGMENTAL_DUPLICATION_CONTENT;
        }
    }

    private static class MappabilityAnnotator
    extends BEDLengthWeightedAnnotator {
        MappabilityAnnotator(FeatureInput<BEDFeature> mappabilityTrackPath) {
            super(mappabilityTrackPath);
        }

        @Override
        public AnnotationKey<Double> getAnnotationKey() {
            return CopyNumberAnnotations.MAPPABILITY;
        }
    }

    static abstract class BEDLengthWeightedAnnotator
    extends IntervalAnnotator<Double> {
        private final FeatureInput<BEDFeature> trackPath;

        BEDLengthWeightedAnnotator(FeatureInput<BEDFeature> trackPath) {
            this.trackPath = trackPath;
        }

        @Override
        Double apply(Locatable interval, ReferenceContext referenceContext, FeatureContext featureContext) {
            double lengthWeightedSum = 0.0;
            List<BEDFeature> features = featureContext.getValues(this.trackPath);
            for (BEDFeature feature : features) {
                double scoreOrNaN = feature.getScore();
                double score = Double.isNaN(scoreOrNaN) ? 1.0 : scoreOrNaN;
                lengthWeightedSum += score * (double)CoordMath.getOverlap((int)feature.getStart(), (int)(feature.getEnd() - 1), (int)interval.getStart(), (int)interval.getEnd());
            }
            return lengthWeightedSum / (double)interval.getLengthOnReference();
        }
    }

    private static class GCContentAnnotator
    extends IntervalAnnotator<Double> {
        private GCContentAnnotator() {
        }

        @Override
        public AnnotationKey<Double> getAnnotationKey() {
            return CopyNumberAnnotations.GC_CONTENT;
        }

        @Override
        Double apply(Locatable interval, ReferenceContext referenceContext, FeatureContext featureContext) {
            Nucleotide.Counter counter = new Nucleotide.Counter();
            counter.addAll(referenceContext.getBases());
            long gcCount = counter.get(Nucleotide.C) + counter.get(Nucleotide.G);
            long atCount = counter.get(Nucleotide.A) + counter.get(Nucleotide.T);
            long totalCount = gcCount + atCount;
            return totalCount == 0L ? Double.NaN : (double)gcCount / (double)totalCount;
        }
    }

    static abstract class IntervalAnnotator<T> {
        IntervalAnnotator() {
        }

        public abstract AnnotationKey<T> getAnnotationKey();

        abstract T apply(Locatable var1, ReferenceContext var2, FeatureContext var3);

        T applyAndValidate(Locatable interval, ReferenceContext referenceContext, FeatureContext featureContext) {
            return this.getAnnotationKey().validate(this.apply(interval, referenceContext, featureContext));
        }
    }
}

