/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.CopyNumberProgramGroup;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.caller.SimpleCopyRatioCaller;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CalledCopyRatioSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CalledLegacySegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.collections.CopyRatioSegmentCollection;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledCopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledLegacySegment;
import org.broadinstitute.hellbender.utils.Utils;

@CommandLineProgramProperties(summary="Calls copy-ratio segments as amplified, deleted, or copy-number neutral", oneLineSummary="Calls copy-ratio segments as amplified, deleted, or copy-number neutral", programGroup=CopyNumberProgramGroup.class)
@DocumentedFeature
public final class CallCopyRatioSegments
extends CommandLineProgram {
    public static final String NEUTRAL_SEGMENT_COPY_RATIO_LOWER_BOUND_LONG_NAME = "neutral-segment-copy-ratio-lower-bound";
    public static final String NEUTRAL_SEGMENT_COPY_RATIO_UPPER_BOUND_LONG_NAME = "neutral-segment-copy-ratio-upper-bound";
    public static final String OUTLIER_NEUTRAL_SEGMENT_COPY_RATIO_Z_SCORE_THRESHOLD_LONG_NAME = "outlier-neutral-segment-copy-ratio-z-score-threshold";
    public static final String CALLING_COPY_RATIO_Z_SCORE_THRESHOLD_LONG_NAME = "calling-copy-ratio-z-score-threshold";
    public static final String LEGACY_SEGMENTS_FILE_SUFFIX = ".igv.seg";
    @Argument(doc="Input file containing copy-ratio segments (.cr.seg output of ModelSegments).", fullName="input", shortName="I")
    private File inputCopyRatioSegmentsFile;
    @Argument(doc="Output file for called copy-ratio segments.", fullName="output", shortName="O")
    private File outputCalledCopyRatioSegmentsFile;
    @Argument(doc="Lower bound on non-log2 copy ratio used for determining copy-neutral segments.", fullName="neutral-segment-copy-ratio-lower-bound", optional=true, minValue=0.0)
    private double neutralSegmentCopyRatioLowerBound = 0.9;
    @Argument(doc="Upper bound on non-log2 copy ratio used for determining copy-neutral segments.", fullName="neutral-segment-copy-ratio-upper-bound", optional=true, minValue=0.0)
    private double neutralSegmentCopyRatioUpperBound = 1.1;
    @Argument(doc="Threshold on z-score of non-log2 copy ratio used for determining outlier copy-neutral segments.  If non-log2 copy ratio z-score is above this threshold for a copy-neutral segment, it is considered an outlier and not used in the calculation of the length-weighted mean and standard deviation used for calling.", fullName="outlier-neutral-segment-copy-ratio-z-score-threshold", optional=true, minValue=0.0)
    private double outlierNeutralSegmentCopyRatioZScoreThreshold = 2.0;
    @Argument(doc="Threshold on z-score of non-log2 copy ratio used for calling segments.", fullName="calling-copy-ratio-z-score-threshold", optional=true, minValue=0.0)
    private double callingCopyRatioZScoreThreshold = 2.0;
    private File outputCalledLegacySegmentsFile;

    @Override
    protected Object doWork() {
        this.validateArguments();
        CopyRatioSegmentCollection copyRatioSegments = new CopyRatioSegmentCollection(this.inputCopyRatioSegmentsFile);
        CalledCopyRatioSegmentCollection calledCopyRatioSegments = new SimpleCopyRatioCaller(copyRatioSegments, this.neutralSegmentCopyRatioLowerBound, this.neutralSegmentCopyRatioUpperBound, this.outlierNeutralSegmentCopyRatioZScoreThreshold, this.callingCopyRatioZScoreThreshold).makeCalls();
        this.logger.info(String.format("Writing called segments to %s...", this.outputCalledCopyRatioSegmentsFile.getAbsolutePath()));
        calledCopyRatioSegments.write(this.outputCalledCopyRatioSegmentsFile);
        CalledLegacySegmentCollection legacySegmentCollection = CallCopyRatioSegments.createCalledLegacySegmentCollection(calledCopyRatioSegments);
        this.logger.info(String.format("Writing called segments in IGV-compatible format to %s...", this.outputCalledLegacySegmentsFile.getAbsolutePath()));
        legacySegmentCollection.write(this.outputCalledLegacySegmentsFile);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    private void validateArguments() {
        Utils.validateArg(this.neutralSegmentCopyRatioLowerBound < this.neutralSegmentCopyRatioUpperBound, String.format("Copy-neutral lower bound (%s) must be less than upper bound (%s).", NEUTRAL_SEGMENT_COPY_RATIO_LOWER_BOUND_LONG_NAME, NEUTRAL_SEGMENT_COPY_RATIO_UPPER_BOUND_LONG_NAME));
        CopyNumberArgumentValidationUtils.validateInputs(this.inputCopyRatioSegmentsFile);
        this.outputCalledLegacySegmentsFile = CallCopyRatioSegments.createCalledLegacySegmentsFile(this.outputCalledCopyRatioSegmentsFile);
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputCalledCopyRatioSegmentsFile, this.outputCalledLegacySegmentsFile);
    }

    @VisibleForTesting
    static File createCalledLegacySegmentsFile(File calledCopyRatioSegmentsFile) {
        return new File(FilenameUtils.removeExtension((String)calledCopyRatioSegmentsFile.getAbsolutePath()) + LEGACY_SEGMENTS_FILE_SUFFIX);
    }

    private static CalledLegacySegmentCollection createCalledLegacySegmentCollection(CalledCopyRatioSegmentCollection segments) {
        return new CalledLegacySegmentCollection((SampleLocatableMetadata)segments.getMetadata(), segments.getRecords().stream().map(r -> CallCopyRatioSegments.convert(r, ((SampleLocatableMetadata)segments.getMetadata()).getSampleName())).collect(Collectors.toList()));
    }

    private static CalledLegacySegment convert(CalledCopyRatioSegment segment, String sampleName) {
        return new CalledLegacySegment(sampleName, segment.getInterval(), segment.getNumPoints(), segment.getMeanLog2CopyRatio(), segment.getCall());
    }
}

