/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.copynumber;

import com.google.common.collect.ImmutableList;
import htsjdk.samtools.SAMSequenceDictionary;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.tools.copynumber.arguments.CopyNumberArgumentValidationUtils;
import org.broadinstitute.hellbender.tools.copynumber.datacollection.AllelicCountCollector;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.Metadata;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.MetadataUtils;
import org.broadinstitute.hellbender.tools.copynumber.formats.metadata.SampleLocatableMetadata;
import org.broadinstitute.hellbender.utils.Nucleotide;

@CommandLineProgramProperties(summary="Collects reference and alternate allele counts at specified sites", oneLineSummary="Collects reference and alternate allele counts at specified sites", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
public final class CollectAllelicCounts
extends LocusWalker {
    private static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 30;
    static final int DEFAULT_MINIMUM_BASE_QUALITY = 20;
    static final List<ReadFilter> DEFAULT_ADDITIONAL_READ_FILTERS = ImmutableList.of((Object)ReadFilterLibrary.MAPPED, (Object)ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT, (Object)ReadFilterLibrary.NOT_DUPLICATE, (Object)new MappingQualityReadFilter(30));
    public static final String MINIMUM_BASE_QUALITY_LONG_NAME = "minimum-base-quality";
    @Argument(doc="Output file for allelic counts.", fullName="output", shortName="O")
    private File outputAllelicCountsFile;
    @Argument(doc="Minimum base quality.  Base calls with lower quality will be filtered out of pileups.", fullName="minimum-base-quality", minValue=0.0, optional=true)
    private int minimumBaseQuality = 20;
    private AllelicCountCollector allelicCountCollector;

    @Override
    public boolean emitEmptyLoci() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>(super.getDefaultReadFilters());
        readFilters.addAll(DEFAULT_ADDITIONAL_READ_FILTERS);
        return readFilters;
    }

    @Override
    public void onTraversalStart() {
        this.validateArguments();
        SampleLocatableMetadata metadata = (SampleLocatableMetadata)MetadataUtils.fromHeader(this.getHeaderForReads(), Metadata.Type.SAMPLE_LOCATABLE);
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (!CopyNumberArgumentValidationUtils.isSameDictionary(metadata.getSequenceDictionary(), sequenceDictionary)) {
            this.logger.warn("Sequence dictionary in BAM does not match the master sequence dictionary.");
        }
        this.allelicCountCollector = new AllelicCountCollector(metadata);
        this.logger.info("Collecting allelic counts...");
    }

    private void validateArguments() {
        CopyNumberArgumentValidationUtils.validateOutputFiles(this.outputAllelicCountsFile);
    }

    @Override
    public Object onTraversalSuccess() {
        this.logger.info(String.format("Writing allelic counts to %s...", this.outputAllelicCountsFile.getAbsolutePath()));
        this.allelicCountCollector.getAllelicCounts().write(this.outputAllelicCountsFile);
        this.logger.info(String.format("%s complete.", this.getClass().getSimpleName()));
        return null;
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        byte refAsByte = referenceContext.getBase();
        this.allelicCountCollector.collectAtLocus(Nucleotide.decode(refAsByte), alignmentContext.getBasePileup(), alignmentContext.getLocation(), this.minimumBaseQuality);
    }
}

